#include "mbed.h"
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"

LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;

InterruptIn user_button(USER_BUTTON);


extern "C" int32_t CountItems();
extern "C" int32_t SumAllFrequencies();
extern "C" uint8_t * GetWordAt(int32_t i);   // NOTE: returns a pointer to a string
extern "C" int16_t GetFreqAt(int32_t i);      // NOTE: return the value of the frequency count





void button_pressed(){

    lcd.Clear(LCD_COLOR_YELLOW);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
}


void button_released(){
    
    }

void push_button_Callback() // Only executes when button interrupt received
{
    
    


    user_button.rise(&button_pressed);
    user_button.fall(&button_released);       
}


int main()
{
    int32_t words;
    int32_t frequencies;
    int16_t frequency;
    uint8_t *word;
    uint8_t text[30];
    uint8_t status;

    

    
    push_button_Callback();
  
    
    BSP_LCD_SetFont(&Font20);

    
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"DEMO", CENTER_MODE);
    wait(1);

    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());

    if (status != TS_OK) {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT FAIL", CENTER_MODE);
    } else {
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT OK", CENTER_MODE);
    }


    wait(1);
    lcd.Clear(LCD_COLOR_BLUE);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);

    frequencies = SumAllFrequencies();
    words = CountItems();
    words = 4;


  

    sprintf((char*)text, "words=%d", words);
    lcd.DisplayStringAt(0, LINE(3), (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "frequencies=%d", frequencies);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)&text, LEFT_MODE);
    
    
    while(1) {
        //Loop Through maximum word
        for(int32_t i=0; i < words; i++){
                word = GetWordAt(i);
                for(int i = 0; word[i] != 0; i++){
                sprintf((char*)text, "word=%d", *(word+i));
                lcd.DisplayStringAt(0, LINE(6), (uint8_t *)&text, LEFT_MODE);
                wait(1);
                }
            }
            for(int32_t i=0; i < words; i++){
                frequency = GetFreqAt(i);
                sprintf((char*)text, "frequency=%d", frequency);
                lcd.DisplayStringAt(0, LINE(5), (uint8_t *)&text, LEFT_MODE);
            }
            
       
    }
}
