void InitTOFSensors()
{
    DigitalOut xshut1(XSHUT_pin1);
    DigitalOut xshut2(XSHUT_pin2);
    xshut1 = 0;
    xshut2 = 0;
    
    Sensor3.setAddress(Sensor3_newAddress);
    printf("sensor3: %d\n",Sensor3.getAddress());
    xshut2 = 1;
    wait_ms(10);
    
    Sensor2.setAddress(Sensor2_newAddress);
    printf("sensor2: %d sensor3: %d\n",Sensor2.getAddress(),Sensor3.getAddress());
    xshut1 = 1;
    wait_ms(10);
    
    printf("sensor1: %d sensor2: %d sensor3: %d\n",Sensor1.getAddress(),Sensor2.getAddress(),Sensor3.getAddress());
    
    Sensor1.init();
    Sensor2.init();
    Sensor3.init();

    Sensor1.setSignalRateLimit(SignalRateLimit);
    Sensor2.setSignalRateLimit(SignalRateLimit);
    Sensor3.setSignalRateLimit(SignalRateLimit);

    Sensor1.setMeasurementTimingBudget(MeasurementBudget);
    Sensor2.setMeasurementTimingBudget(MeasurementBudget);
    Sensor3.setMeasurementTimingBudget(MeasurementBudget);

    Sensor1.setTimeout(Timeout);
    Sensor2.setTimeout(Timeout);
    Sensor3.setTimeout(Timeout);

    Sensor1.startContinuous();
    Sensor2.startContinuous();
    Sensor3.startContinuous();
}

void PrintTOFDistances()
{
    front_Distance = Sensor1.readRangeContinuousMillimeters();
    float front_DistanceCM = (float)( front_Distance  / 10.0);

    left_Distance = Sensor2.readRangeContinuousMillimeters() ;
    float left_DistanceCM = (float)(left_Distance / 10.0);

    right_Distance = Sensor3.readRangeContinuousMillimeters();
    float right_DistanceCM = (float)(right_Distance / 10.0);
    
    printf("F: %.2f L: %.2f R: %.2f",front_DistanceCM,left_DistanceCM,right_DistanceCM);
}
