#include "mbed.h"
#include "ESP8266.h"
 

Serial pc(USBTX,USBRX);
AnalogIn inputPin(PTB1); // pir senor input
ESP8266 wifi(PTE0, PTE1, 115200); // baud rate for wifi
char snd[255],rcv[1000];
 
#define IP "184.106.153.149" // thingspeak.com IP Address
 
float val = 0; // value to holed the high/low info from pir from pin D2
 
/************ WiFi INTIALIZATION *********/
 
void wifi_initialize(void);
void wifi_send(void);
 
int main () {
    
    pc.baud(9600);   
    pc.printf("SET mode to AP\r\n");
    wifi.SetMode(1);    // set ESP mode to 1
    wifi.RcvReply(rcv, 1000);    //receive a response from ESP
    pc.printf("%s",rcv);    //Print the response onscreen
    pc.printf("Connecting to AP\r\n");
    wifi.Join("Eduvance", "eduvance123");     // Your wifi username & Password 
    wifi.RcvReply(rcv, 1000);    //receive a response from ESP
    pc.printf("%s", rcv);    //Print the response onscreen
    wait(8);     //waits for response from ESP
    pc.printf("Getting IP\r\n");    //get IP addresss from the connected AP
    wifi.GetIP(rcv);    //receive an IP address from the AP
    pc.printf("%s", rcv);
    wait(5); // Delay 5 sec to give the pir time to get snapshut of the surrounding
    pc.printf("Initializing WiFi\r\n");
    //wifi_initialize();
    while (1) 
    {      
        val = inputPin.read();
        pc.printf("Sending WiFi information\n\r");
        wifi_send();
        wait(2.0f);
        wait(1.5f);
        }
    }
 
void wifi_send(void){
   
    strcpy(snd,"AT+CIPMODE=0");//Setting WiFi into MultiChannel mode
    wifi.SendCMD(snd);
    pc.printf(snd);
    wifi.RcvReply(rcv, 3000);
    pc.printf("%s", rcv);
  
    //WIFI updates the Status to Thingspeak servers//
    strcpy(snd,"AT+CIPMUX=1");//Setting WiFi into MultiChannel mode
    wifi.SendCMD(snd);
    pc.printf(snd);
    wifi.RcvReply(rcv, 3000);
    pc.printf("%s", rcv);
  
  
    sprintf(snd,"AT+CIPSTART=4,\"TCP\",\"%s\",80",IP); //Initiate connection with THINGSPEAK server 
    wifi.SendCMD(snd);
    pc.printf(snd);
    wifi.RcvReply(rcv, 3000);
    pc.printf("%s", rcv);
 
    strcpy(snd,"AT+CIPSEND=4,47");    //Send Number of open connections,Characters to send 
    wifi.SendCMD(snd);
    pc.printf(snd);
    wifi.RcvReply(rcv, 3000);
    pc.printf("%s", rcv);
  
    
    sprintf(snd,"GET /update?key=ZL31BTC0X4LKXGOT&field1=%2.2f\r\n",val); //Post values to thingspeak
    pc.printf("%s",snd);
    wifi.SendCMD(snd);
    wifi.RcvReply(rcv, 3000);
    pc.printf("%s", rcv);
  
    wifi.SendCMD("AT+CIPCLOSE"); //Close the connection to server
    wifi.RcvReply(rcv, 3000);
    pc.printf("%s", rcv);
}