/***************** For test only ****************/

#include "mbed.h"
#include "ColorMbed.h"

ColorMbed dotmatrix;
Timer t;
Serial pc(D1, D0);
DigitalIn sw(USER_BUTTON);

uint8_t blue[3] = {0,5,0};
uint8_t green[3] = {0,255,0};
uint8_t red[3] = {0,0,255};
uint8_t M[3] = {0,50,100};
uint8_t I[3] = {100,0,0};
uint8_t map_led[8] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
uint8_t boss_led[8] = {0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
uint8_t hero_led[8] = {0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
uint8_t M_led[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
uint8_t I_led[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

char board[8][8] = {{'D','O','O','O','O','O','O','O'},
                    {'O','O','O','O','O','O','O','O'},
                    {'O','O','O','O','O','O','O','O'},
                    {'O','O','O','O','O','O','O','O'},
                    {'O','O','O','O','O','O','O','O'},
                    {'O','O','O','O','O','O','O','O'},
                    {'O','O','O','O','O','O','O','O'},
                    {'H','O','O','O','O','O','O','O'}};
                  
int bit_m[8][8] = {{0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0}};
                  
int bit_i[8][8] = {{0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0}};

int position_x = 7;
int position_y = 0;
int position_mission = 1;
char hero = 'H';

void print_position(){
    pc.printf("position is [%d,%d]\n",position_x,position_y);   
}

void print_mission(){
    pc.printf("mission is %d\n",position_mission);   
}

void mission(){
    if (position_mission >= 1 && position_mission < 9){
        position_x = 7;
        position_y = position_mission - 1;    
    }     
    if (position_mission >= 9 && position_mission < 17){
        position_x = 6;
        position_y = 16 - position_mission;    
    }
    if (position_mission >= 17 && position_mission < 25){
        position_x = 5;
        position_y = position_mission - 17;   
    }
    if (position_mission >= 25 && position_mission < 33){
        position_x = 4;
        position_y = 32 - position_mission;     
    }
    if (position_mission >= 33 && position_mission < 41){
        position_x = 3;
        position_y = position_mission - 33;     
    }
    if (position_mission >= 41 && position_mission < 49){
        position_x = 2;
        position_y = 48 - position_mission;  
    }
    if (position_mission >= 49 && position_mission < 57){
        position_x = 1;
        position_y = position_mission - 49;     
    }
    if (position_mission >= 57 && position_mission < 65){
        position_x = 0;
        position_y = 64 - position_mission;    
    }
    if (position_mission >=65){
        position_x = 0;
        position_y = 0;
        position_mission = 64;
    }
}

void move(int ran){
    int walk_x = position_x;
    int walk_y = position_y;
    
    position_mission = position_mission + ran;
    mission();
    
    if (board[position_x][position_y]=='O'){
        board[walk_x][walk_y]='O';
        board[position_x][position_y] = hero;
        pc.printf("walk is %d\n",ran);
    }
    else{
        board[walk_x][walk_y]='O';
        board[position_x][position_y] = hero;
        pc.printf("walk is %d\n",ran);
    }  
}

void map(){
    for(int i=0;i<8;i++){
        pc.printf("\n");
        for(int j=0;j<8;j++){
            pc.printf("_%c",board[i][j]);
        }
    }
    pc.printf("\n"); 
}

void random() {
    srand((unsigned)time(0)); 
    int ran = (rand()%6)+1;
    move(ran);
}

void monster_easy(){

        srand((unsigned)time(0));
        int mon1 = (rand()%3)+2;    //2-4
        int B1 = (rand()%4)+5;      //5-8
        int mon2 = (rand()%4)+9;    //9-12
        int T1 = (rand()%4)+13;      //13-16
        int mon3 = (rand()%4)+17;    //17-20
        int B2 = (rand()%4)+21;      //21-24
        int mon4 = (rand()%4)+25;    //25-28
        int T2 = (rand()%4)+29;      //29-32
        int mon5 = (rand()%4)+33;    //33-36
        int B3 = (rand()%4)+37;      //37-40
        int mon6 = (rand()%4)+41;    //41-44
        int T3 = (rand()%4)+45;      //45-48
        int mon7 = (rand()%4)+49;    //49-52
        int B4 = (rand()%4)+53;      //53-56
        int mon8 = (rand()%4)+57;    //57-60
        int T4 = (rand()%3)+61;      //61-63
        
        position_mission = mon1;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        
        position_mission = mon2;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }

        position_mission = mon3;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
    
        position_mission = mon4;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
     
        position_mission = mon5;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
   
        position_mission = mon6;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
    
        position_mission = mon7;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
     
        position_mission = mon8;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        
        position_mission = B1;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'B';    
        }
        
        position_mission = B2;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'B';    
        }
 
        position_mission = B3;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'B';    
        }
        
        position_mission = B4;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'B';    
        }
        
        position_mission = T1;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'T';    
        }
            
        position_mission = T2;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'T';    
        }
            
        position_mission = T3;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'T';    
        }
        
        position_mission = T4;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'T';    
        }

        position_mission = 1;
        mission();
}

void monster_medium(){

        srand((unsigned)time(0));
        int mon1 = (rand()%3)+2;     //2-4
        int B1 = (rand()%3)+5;       //5-7
        int mon2 = (rand()%3)+8;     //8-10
        int T1 = (rand()%3)+11;      //11-13
        int mon3 = (rand()%3)+14;    //14-16
        int B2 = (rand()%3)+17;      //17-19
        int mon4 = (rand()%3)+20;    //20-22
        int T2 = (rand()%3)+23;      //23-25
        int mon5 = (rand()%3)+26;    //26-28
        int B3 = (rand()%3)+29;      //29-31
        int mon6 = (rand()%3)+32;    //32-34
        int T3 = (rand()%3)+35;      //35-37
        int mon7 = (rand()%3)+38;    //38-40
        int B4 = (rand()%3)+41;      //41-43
        int mon8 = (rand()%3)+44;    //44-46
        int T4 = (rand()%3)+47;      //47-49
        int mon9 = (rand()%3)+50;    //50-52
        int B5 = (rand()%3)+53;      //53-55
        int mon10 = (rand()%3)+56;   //56-58
        int T5 = (rand()%3)+59;      //59-61
        int mon11 = (rand()%1)+62;   //62
        int mon12 = (rand()%1)+63;   //63
        
        position_mission = mon1;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        
        position_mission = mon2;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }

        position_mission = mon3;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
    
        position_mission = mon4;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
     
        position_mission = mon5;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
   
        position_mission = mon6;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
    
        position_mission = mon7;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
     
        position_mission = mon8;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        position_mission = mon9;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        position_mission = mon10;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        
        position_mission = mon11;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        
        position_mission = mon12;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        
        position_mission = B1;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'B';    
        }
        
        position_mission = B2;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'B';    
        }
 
        position_mission = B3;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'B';    
        }
        
        position_mission = B4;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'B';    
        }
        
        position_mission = B5;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'B';    
        }
        
        position_mission = T1;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'T';    
        }
            
        position_mission = T2;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'T';    
        }
            
        position_mission = T3;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'T';    
        }
        
        position_mission = T4;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'T';    
        }
        
        position_mission = T5;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'T';    
        }

        position_mission = 1;
        mission();
}

void monster_hard(){

        srand((unsigned)time(0));
        int mon1 = (rand()%3)+2;     //2-4
        int B1 = (rand()%3)+5;       //5-7
        int mon2 = (rand()%3)+8;     //8-10
        int T1 = (rand()%3)+11;      //11-13
        int mon3 = (rand()%3)+14;    //14-16
        int B2 = (rand()%3)+17;      //17-19
        int mon4 = (rand()%2)+20;    //20-21-------------2
        int T2 = (rand()%2)+22;      //22-23
        int mon5 = (rand()%2)+24;    //24-25
        int B3 = (rand()%2)+26;      //26-27
        int mon6 = (rand()%2)+28;    //28-29
        int T3 = (rand()%2)+30;      //30-31
        int mon7 = (rand()%2)+32;    //32-33
        int B4 = (rand()%2)+34;      //34-35
        int mon8 = (rand()%2)+36;    //36-37
        int T4 = (rand()%2)+38;      //38-39
        int mon9 = (rand()%2)+40;    //40-41
        int B5 = (rand()%2)+42;      //42-43
        int mon10 = (rand()%2)+44;   //44-45
        int T5 = (rand()%2)+46;      //46-47
        int mon11 = (rand()%2)+48;   //48-49
        int B6 = (rand()%2)+50;      //50-51
        int mon12 = (rand()%2)+52;   //52-53
        int T6 = (rand()%2)+54;      //54-55
        int mon13 = (rand()%2)+56;   //56-57
        int mon14 = (rand()%2)+58;   //58-59
        int mon15 = (rand()%2)+60;   //60-61
        int mon16 = (rand()%2)+62;   //62-63
        
        position_mission = mon1;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        
        position_mission = mon2;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }

        position_mission = mon3;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
    
        position_mission = mon4;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
     
        position_mission = mon5;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
   
        position_mission = mon6;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
    
        position_mission = mon7;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
     
        position_mission = mon8;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        position_mission = mon9;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        position_mission = mon10;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        
        position_mission = mon11;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        
        position_mission = mon12;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        
        position_mission = mon13;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        
        position_mission = mon14;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        
        position_mission = mon15;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        
        position_mission = mon16;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'M';    
        }
        
        position_mission = B1;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'B';    
        }
        
        position_mission = B2;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'B';    
        }
 
        position_mission = B3;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'B';    
        }
        
        position_mission = B4;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'B';    
        }
        
        position_mission = B5;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'B';    
        }
        
        position_mission = B6;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'B';    
        }
        
        position_mission = T1;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'T';    
        }
            
        position_mission = T2;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'T';    
        }
            
        position_mission = T3;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'T';    
        }
        
        position_mission = T4;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'T';    
        }
        
        position_mission = T5;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'T';    
        }
        
        position_mission = T6;
        mission();
        if (board[position_x][position_y]=='O'){
            board[position_x][position_y] = 'T';    
        }

        position_mission = 1;
        mission();
}

void led2(){ 
    if (position_x==7){
        hero_led[position_y] = 0x01;   
    }
    if (position_x==6){
        hero_led[position_y] = 0x02;   
    }  
    if (position_x==5){
        hero_led[position_y] = 0x04;   
    }  
    if (position_x==4){
        hero_led[position_y] = 0x08;   
    }  
    if (position_x==3){
        hero_led[position_y] = 0x10;   
    }  
    if (position_x==2){
        hero_led[position_y] = 0x20;   
    }  
    if (position_x==1){
        hero_led[position_y] = 0x40;   
    }  
    if (position_x==0){
        hero_led[position_y] = 0x80;   
    }   
}

void read_m(){
    for(int i=0;i<8;i++){
        for(int j=0;j<8;j++){
            if (board[j][i]=='M'){
                bit_m[i][j] = 1;
            }
            else{
                bit_m[i][j] = 0;
            }
        }
    }
}

void read_i(){
    for(int i=0;i<8;i++){
        for(int j=0;j<8;j++){
            if (board[j][i]=='B' || board[j][i]=='T'){
                bit_i[i][j] = 1;
            }
            else{
                bit_i[i][j] = 0;
            }
        }
    }
}

void print_bit_m(){
    for(int i=0;i<8;i++){
        pc.printf("\n");
        for(int j=0;j<8;j++){
            pc.printf("%d",bit_m[i][j]);
        }
    }
    pc.printf("\n");   
}

void print_bit_i(){
    for(int i=0;i<8;i++){
        pc.printf("\n");
        for(int j=0;j<8;j++){
            pc.printf("%d",bit_i[i][j]);
        }
    }
    pc.printf("\n");   
}

void cal_m(){
    int a,b,c;
    for (int i=0;i<8;i++){
        a = bit_m[i][0]*8+bit_m[i][1]*4+bit_m[i][2]*2+bit_m[i][3];
//        pc.printf("(%d)",a);
        b = bit_m[i][4]*8+bit_m[i][5]*4+bit_m[i][6]*2+bit_m[i][7];
//        pc.printf("(%d)",b);
        c = a*16+b;
//        pc.printf("(%d)",c);
        M_led[i] = c;
//        pc.printf("(%2x)",M_led[i]);
    }
}

void cal_i(){
    int a,b,c;
    for (int i=0;i<8;i++){
        a = bit_i[i][0]*8+bit_i[i][1]*4+bit_i[i][2]*2+bit_i[i][3];
//        pc.printf("(%d)",a);
        b = bit_i[i][4]*8+bit_i[i][5]*4+bit_i[i][6]*2+bit_i[i][7];
//        pc.printf("(%d)",b);
        c = a*16+b;
//        pc.printf("(%d)",c);
        I_led[i] = c;
//        pc.printf("(%2x)",M_led[i]);
    }
}

    //int y = 85;
//    pc.printf("(%d)",y);
//    pc.printf("(%2x)",y);
//    M_led[1] = y;
//    pc.printf("(%2x)",M_led[1]);

int main(){

  dotmatrix.init();
  
  //monster_easy();
  //monster_medium();
  monster_hard();
  map();
  print_mission();
  print_position();
  read_m();
//  print_bit_m();
  cal_m();
  read_i();
//  print_bit_i();
  cal_i();
  
    while(1){
        dotmatrix.display_pic(map_led,blue);
        dotmatrix.display_pic(hero_led,green);
        dotmatrix.display_pic(boss_led,red);
        dotmatrix.display_pic(M_led,M);
        dotmatrix.display_pic(I_led,I);
        
        if (sw==0){
            
            hero_led[position_y] = 0x00;
            random();
            map();
            print_mission();
            print_position();
            led2();
            
            bit_m[position_x][position_y] = 0;
            read_m();
            cal_m();
            bit_i[position_x][position_y] = 0;
            read_i();
            cal_i();
        }
    }
}
