#include "mbed.h"

Serial bt(PA_15,PB_7);
Serial pc(D1,D0);
Serial lcd(PA_11,PA_12);

char button,press,test_pop;
uint8_t test,test_get;
int state,size,count_ok,mode_name,mode_button,count_press,page,game_mode,set_mode_loop;
char alphabet [26]  = {'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'};
char user_name[10];

void SGMP_First_Page(){
    pc.printf("SGMP\nPress Enter to start\n");
    while(1){
        
        if(bt.readable()) {
            button = bt.getc();
            if (button == 'E'){
                button = NULL;
                break;
            }
        }
    }
}

void set_name() {
    
    state = 0;
    size = 0;
    count_ok = 0;
    mode_name = 1;
    
    while(mode_name){
        if(bt.readable()) {
            button = bt.getc();
//            pc.printf("button = %c \n",button);
//            }}}
            switch(button){
                case 'U':                      //UP Button
                    if(state == 0){
                        state = 25;
                    }
                    else{
                        state--; 
                    }
                    lcd.printf("%c",char(alphabet[state]));
                    pc.printf("alphabet = %c     ",alphabet[state]);
                    pc.printf("    name = %s     \n",user_name);
//                    pc.printf("    size = %d     ",size);
//                    pc.printf("    state = %d \n",state);
                    wait_ms(600);
                    count_ok = 0;
                    break;
                case 'D':                     //DOWN Button
                    if(state == 25){
                        state = 0;
                    }
                    else{
                        state++; 
                    }
                    lcd.printf("%c",char(alphabet[state]));
                    pc.printf("alphabet = %c     ",alphabet[state]);
                    pc.printf("    name = %s     \n",user_name);
//                    pc.printf("    size = %d     ",size);
//                    pc.printf("    state = %d \n",state);
//                    pc.printf("DOWN\n");
                    wait_ms(600);
                    count_ok = 0;
                    break;
                case 'O':                     //OK Button
                    user_name[size++] = alphabet[state];
                    lcd.printf("k%sf",user_name);
                    pc.printf("alphabet = %c     ",alphabet[state]);
                    pc.printf("    name = %s     \n",user_name);
//                    pc.printf("    size = %d     ",size);
//                    pc.printf("    state = %d \n",state);
                    
//                    pc.printf("%c\n",button);
                    
                    wait_ms(600);
                    
                    break;
                case 'C':                     //OK Button
                    if(size > 0){
                        size--;
                        user_name[size] = NULL;
                    }
                    lcd.printf("k%sf",user_name);
                    pc.printf("alphabet = %c     ",alphabet[state]);
                    pc.printf("    name = %s     \n",user_name);
//                    pc.printf("    size = %d     ",size);
//                    pc.printf("    state = %d \n",state);
                    
//                    pc.printf("%c\n",button);
                    
                    wait_ms(600);
                    
                    break;
                case 'E':                     //Enter Button
                    page = 3;
                    lcd.printf("x");
                    mode_name = 0;
                    
//                    pc.printf("ENTER\n");
//                    wait_ms(600);
                    break;
                    
            }
        }

    }
//    lcd.printf("Name = %s",user_name);
//    pc.printf("alphabet = %c     ",alphabet[state]);
    pc.printf("    name = %s     \n",user_name);
//    pc.printf("    size = %d     ",size);
//    pc.printf("    state = %d \n",state);
//    return user_name;
}

int set_mode(){
    set_mode_loop = 1;
//    lcd.printf("%d",game_mode);
    while(set_mode_loop){
        if(bt.readable()) {
            button = bt.getc();
            switch(button){
                case 'U':
                    if(game_mode == 1){
                        game_mode = 3;
                    }
                    else{
                        game_mode--;
                    }
                    wait_ms(600);
                    lcd.printf("%d",game_mode);
                    pc.printf("set_mode = %d \n",game_mode);
                    break;
                case 'D':
                    if(game_mode == 3){
                        game_mode = 1;
                    }
                    else{
                        game_mode++;
                    }
                    wait_ms(600);
                    lcd.printf("%d",game_mode);
                    pc.printf("set_mode = %d \n",game_mode);
                    break;
                case 'E':
                    set_mode_loop = 0;
                    break;
            }
        }
    }
    return game_mode;  
}

int main(){
    lcd.baud(9600);
    page = 1;
    game_mode = 1;
    while(1){
        if(page == 1){
            lcd.printf("p001f");
            SGMP_First_Page();
            page = 2;
        }
        else if (page == 2){
            lcd.puts("p002f");
            wait_ms(500);
            lcd.printf("%c",char(alphabet[state]));
            button = NULL;
            wait_ms(600);
            set_name();
            
            pc.printf("finish your name is : %s \n",user_name);
            
        }
        else if (page == 3){
            lcd.puts("p003f");
            button = NULL;
            wait_ms(600);
            set_mode();
            page = 4;
//            lcd.printf("set_mode = %d \n",game_mode);
            pc.printf("finish set_mode = %d \n",game_mode);
        }
    }
//-----------------------------------------------------------------//
//    char map;
//    while(1){
//        if(bt.readable()) {
//            test_pop = bt.getc();
//            pc.printf("%c",test_pop);
//            
//        }
//    }
//-----------------------------------------------------------------//
}
