#include "mbed.h"

Serial pc(USBTX, USBRX);    // I/O amb l'ordinador
AnalogIn fIn(p17);          //p15 -p20 accepten AnalogIn
float fMitja, fActual, alpha;
int p, pAnt;
Timer tFlanc;
float soroll;               //Valor absolut màxim del soroll 
int cont;
float periode;

int main() {
    p=0;
    pAnt=0;
    fMitja=fIn;
    alpha=0.999;
    cont=0;
    soroll = 0.001;

    
    while(1) {
      fActual=fIn;
      fMitja=(alpha*fMitja)+((1-alpha)*fActual);  //filtre alfa
      
      //pc.printf("%f\r\n", fActual);
      
      //Es resta l'offset a la senyal tenint en compte el soroll i es comprova si l'ona està per sobre del y=0 (p=1) o per sota (p=0)
      if( (fActual-fMitja) > soroll ) p=1;         
      else if( (fActual-fMitja) < -soroll ) p=0;
      
      //Detectar flanc pujada
      if( (pAnt==0) && (p==1) ) {
          cont++;
          if (cont==1) {
              tFlanc.start();
              }
          if(cont==2){
              tFlanc.stop();
              periode = tFlanc.read();
              tFlanc.reset();
              cont=0;
              pc.printf("Periode: %f \r\n",periode);
          }
      }
      pAnt=p;
      
      wait(0.0001);
      //pc.printf("%f \r\n",fActual);
      
    }
}
