#pragma once 
#include <string>
//#include "Uuid.h"
#include "mbed.h"
#include "EthernetInterface.h"

using namespace std;

#define IPSTR "101.201.199.150"
#define PORT 80
#define BUFSIZE 1024*20

struct http_post_params
{
	string cmd;
	string url;
	string host;
	string token;
	string content;
};

struct http_post_params bc_params[] = 
{
	{"info",				"/info",				"testbc.hwelltech.com", "", "{}"},
	{"create-key",			"/mockhsm/create-key",  "testbc.hwelltech.com", "", "{\"alias\":\"mbed_key_a1\",\"client_token\":\"a37b1fe0-d952-4e1e-a09f-d1fe2c9dc282\"}"},
	{"create-account",		"/create-account",		"testbc.hwelltech.com", "", "[{\"alias\":\"mbed_account_a1\",\"tags\":{},\"quorum\":1,\"root_xpubs\":[\"62b33131fff6493ce37cf86396984902932baaf08eb5260cc17a4138f0403e4f261a0569c75aeddfd8f09548b891b360a8e72a514c082826920d3f87e325ea9b\"],\"client_token\":\"641dc851-4bce-45d8-bedb-96766abff223\"}]"},
	{"create-asset",		"/create-asset",		"testbc.hwelltech.com", "", "[{\"alias\":\"mbed_asset\",\"tags\":{},\"definition\":{},\"quorum\":1,\"root_xpubs\":[\"62b33131fff6493ce37cf86396984902932baaf08eb5260cc17a4138f0403e4f261a0569c75aeddfd8f09548b891b360a8e72a514c082826920d3f87e325ea9b\"],\"client_token\":\"de4bf755-1278-400d-9a16-bdca5ffaed0f\"}]"},
	{"list-assets",			"/list-assets",			"testbc.hwelltech.com", "", "{\"filter\":\"id='bd3b443fc05c2d1d6be7c27d6a34c98070efa178fc53d2ddcd444542ef5b7a8b'\"}"},
	{"build-transaction",	"/build-transaction",	"testbc.hwelltech.com", "", "[{\"actions\":[{\"account_alias\":\"t_acc_1\",\"asset_alias\":\"t_asset\",\"amount\":123,\"reference_data\":{},\"type\":\"spend_account\"},{\"account_alias\":\"t_acc_2\",\"asset_alias\":\"t_asset\",\"amount\":123,\"reference_data\":{},\"type\":\"control_account\"}]}]"},
	{"sign-transaction",	"/sign-transaction",	"testbc.hwelltech.com", "", "{\"transactions\":[{\"raw_transaction\":\"07010700fae2ffd5e52b000101710187249e9a82f75589f67b6d3166454b8cca8882d7f74c456f4b8b14278f84f4ee4fa592bcb4e3aaaf2f6a7460ce61b708ea9289af5519be46d1481b83c1f237a110c445012b766baa2029072ca3b5f2b3f77d28cc9cb44dbbfe54a03d9a9a95fb60aea517f296adb47d5151ad696c00c0027b7d010002014fa592bcb4e3aaaf2f6a7460ce61b708ea9289af5519be46d1481b83c1f237a110c944012b766baa20754817056c29955a9787b7db7fe98b135d1adecc7986b4c957e57fd2b6da86225151ad696c00c00000014ea592bcb4e3aaaf2f6a7460ce61b708ea9289af5519be46d1481b83c1f237a1107b012b766baa20e10131cfd7c51d3f43c933fe1e7be4ff75860e6bcf3d1a495332305df95b067e5151ad696c00c0027b7d0000\",\"signing_instructions\":[{\"position\":0,\"asset_id\":\"a592bcb4e3aaaf2f6a7460ce61b708ea9289af5519be46d1481b83c1f237a110\",\"amount\":8900,\"witness_components\":[{\"type\":\"signature\",\"quorum\":1,\"keys\":[{\"xpub\":\"eae173767ebfdf7ef6ee10ee4edcd9e809492b97b8a5f3135754924d54641d53337d717aff01468e9561d7b54c04f042f23aee956ec5135654cf111d1cb3fb9d\",\"derivation_path\":[\"014200000000000000\",\"6eea000000000000\"]}],\"signatures\":null}]}],\"local\":true,\"allow_additional_actions\":false}],\"xpubs\":[\"eae173767ebfdf7ef6ee10ee4edcd9e809492b97b8a5f3135754924d54641d53337d717aff01468e9561d7b54c04f042f23aee956ec5135654cf111d1cb3fb9d\"]}"},
	{"submit-transaction",	"/submit-transaction",	"testbc.hwelltech.com", "", "{\"transactions\":[{\"raw_transaction\":\"07010700fae2ffd5e52b000101710187249e9a82f75589f67b6d3166454b8cca8882d7f74c456f4b8b14278f84f4ee4fa592bcb4e3aaaf2f6a7460ce61b708ea9289af5519be46d1481b83c1f237a110c445012b766baa2029072ca3b5f2b3f77d28cc9cb44dbbfe54a03d9a9a95fb60aea517f296adb47d5151ad696c00c0027b7d670300407c1aa8c9e4795a3c7380cc569371d667a0002521f8c1305352463809e1aca463a07474c5f1a4075fbbb14fde77306cf1a7fa448f748aa02c70143d7d1452770a2320e52e1d2df43edd81ef65fd92430a390e42fa05b731aaf87eb5fecd8a74555b57ae8702014fa592bcb4e3aaaf2f6a7460ce61b708ea9289af5519be46d1481b83c1f237a110c944012b766baa20754817056c29955a9787b7db7fe98b135d1adecc7986b4c957e57fd2b6da86225151ad696c00c00000014ea592bcb4e3aaaf2f6a7460ce61b708ea9289af5519be46d1481b83c1f237a1107b012b766baa20e10131cfd7c51d3f43c933fe1e7be4ff75860e6bcf3d1a495332305df95b067e5151ad696c00c0027b7d0000\",\"signing_instructions\":[{\"position\":0,\"asset_id\":\"a592bcb4e3aaaf2f6a7460ce61b708ea9289af5519be46d1481b83c1f237a110\",\"amount\":8900,\"witness_components\":[{\"type\":\"signature\",\"quorum\":1,\"keys\":[{\"xpub\":\"eae173767ebfdf7ef6ee10ee4edcd9e809492b97b8a5f3135754924d54641d53337d717aff01468e9561d7b54c04f042f23aee956ec5135654cf111d1cb3fb9d\",\"derivation_path\":[\"014200000000000000\",\"6eea000000000000\"]}],\"signatures\":[\"7c1aa8c9e4795a3c7380cc569371d667a0002521f8c1305352463809e1aca463a07474c5f1a4075fbbb14fde77306cf1a7fa448f748aa02c70143d7d1452770a\"]}]}],\"local\":true,\"allow_additional_actions\":false}]}"},
	{"list-transactions",	"/list-transactions",	"testbc.hwelltech.com", "", "{\"filter\":\"id='7e5f97a9295370f19e73ccbf3ae8eb66ee01a5551eb073b310aedbde360c0628'\"}"}
};


bool build_post_raw(const string & url, const string & host, const string & token, const string & content, string & post_raw)
{
	bool ret = true;

	post_raw = "";
	post_raw.append("POST "+ url + " HTTP/1.1\n");
	post_raw.append("Host: testbc.hwelltech.com " + host + "\n");
	post_raw.append("Connection: keep-alive\n");
	post_raw.append("accept: application/json\n");
	post_raw.append("content-type: application/json\n");
	string authorization = "Basic YmxvY2tnZW5lcmF0b3I6MTM3NzQzMDJlNTcyYmU4MWMxZmRmZjg2NGZiODA2Yjc2NjcxMzg5NzMwZjBjMDYwZDNlODExNTQ4OGRjNjQ2Mg==";
	//if(!token.empty())
	//	authorization = Base64Encode(token)
	post_raw.append("authorization: " + authorization + "\n");

	char pLen[16] = {0};
	//sprintf_s(pLen, sizeof(pLen), "%d", content.length());
	sprintf(pLen, "%d", content.length());
	string strLen = pLen;

	post_raw.append("Content-Length: " + strLen + "\n");
	post_raw.append("\n\n");
	post_raw.append(content);
	post_raw.append("\r\n\r\n");

	return ret;
}

void test_bc_2()
{
	string strReq = "";
	//build_post_raw();
}


int http_post_bc(const string &strIn,string &strOut)
{
	string strReq;
	string strRep;
	strReq = strIn;

/*
	SOCKET sclient = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);  
	if(sclient == INVALID_SOCKET)  
	{  
		printf("invalid socket!");  
		return 0;  
	}  
*/
	TCPSocketConnection sClient;
/*
	sockaddr_in serAddr;  
	serAddr.sin_family = AF_INET;  
	serAddr.sin_port = htons(80);  
	serAddr.sin_addr.S_un.S_addr = inet_addr("101.201.199.150");  
	if(connect(sclient, (sockaddr *)&serAddr, sizeof(serAddr)) == SOCKET_ERROR)  
	{  
		//����ʧ��   
		printf("connect error !");  
		closesocket(sclient);  
		return 0;  
	}  
	*/
	while (sClient.connect(IPSTR, PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n", IPSTR, PORT);
        wait(1);
    }
    printf("Connected to Server at %s\n", IPSTR);

	int ret = 0;
	//send(sclient, strReq.c_str(), strReq.length(), 0);  
	ret = sClient.send_all((char *)strReq.c_str(), strReq.length());
	if (ret < 0)
	{
		//get last error
		//get errno
		return ret;
	}
	
#ifdef DEBUG_LOG
	cout<< ">>>>>>>>>>HTTP Request (Length = "<< strReq.length() << "):\n" << strReq << endl;
#endif

	char recData[BUFSIZE+1] = {0};  

	ret = 0;
	//ret = recv(sClient, recData, BUFSIZE, 0);  
	ret = sClient.receive(recData, BUFSIZE);
	strRep.append(recData);

	// 第一次收数据可能没有收完全，所以一直收到没有数据为止，这里会堵塞
	while (ret > 0)
	{
		memset(recData,0,BUFSIZE);
		//ret = recv(sClient, recData, BUFSIZE, 0); 
		ret = sClient.receive(recData, BUFSIZE);

		if (ret > 0)
		{
			strRep.append(recData);
		}
	}

	strOut = strRep;
	
#ifdef DEBUG_LOG
	cout<< ">>>>>>>>>>HTTP Response (Length = "<< strRep.length() << "):\n" << strRep << endl;
#endif

	// Clean up
	//closesocket(sClient); 
    sClient.close();
	return 0;
}

/*
void test_uuid()
{
	GUID guid = CreateGuid();
	string strUuid = GuidToString(guid);
	cout<< "uuid = " << strUuid.c_str() << endl;

}
*/