/***********************************************************************
 * Module:  Transaction.h
 * Author:  Administrator
 * Modified: 2017年9月8日 14:50:31
 * Purpose: Declaration of the class Transaction
 * Comment: 恒为区块链核心上的单个事务。
 ***********************************************************************/

#if !defined(__Account_Transaction_h)
#define __Account_Transaction_h
#include <ctime>  // struct tm
#include <string>
#include <map>
#include <list>
#include "Client.h"
#include "Input.h"
#include "Output.h"
#include "MbedJSONValue.h"

using namespace std;

class Object;
class Input;
class Output;


struct Actions
{
	string accounts_alias;
	string asset_alias;
	int amount;
	MbedJSONValue reference_data;
	string type;
};

class Transaction
{
public:
   std::string id;
   struct tm timestamp;
   std::string blockId;
   int blockHeight;
   int position;
   map<string,Object> referenceData;
   std::string isLocal;
   list<Input> inputs;
   list<Output> outputs;


   void setId(const string newId){this->id = newId;};
   string getId(){return this->id;};

   string m_type;
   void setType(const string type){ this->m_type = type;};
   string getType(){ return this->m_type;};

   string sender;
   void setSender(const string & account){ this->sender = account; };

   string receiver;
   void setReceiver(const string & account){ this->receiver = account; };

   int amount;
   void setAmount(int amount){ this->amount = amount; };

   string asset_alias;
   void setAsset(const string & asset){ this->asset_alias = asset; };


   // 后续对应多账户的操作用map管理，暂时只支持少于两个账户的交易
   // 交易过程支持多对多的交易，而且和顺序没什么关系，只要amount达到平衡就可以
   map<string,Actions> m_mapActions;
   vector<Actions> m_vctActions;
   

   string buildTransaction();
   string buildTransaction(string type);
   string buildTransaction(vector<Actions> &actions);
   //string /mockhsm/sign-transaction;
   string signTransaction();
   string submitTransaction();
   string listTransactions();


protected:
private:
	Client client;
	MbedJSONValue m_valRep;
	MbedJSONValue m_valXpub;
	string m_strXpub;

};

#endif