#include "mbed.h"
#include "EthernetInterface.h"
//#include "SDFileSystem.h"
#include <stdio.h>
#include "uniqueCPUID.h"
#include <sstream>  // header of stringsteam

#include <iostream>  
#include <string>  
#include "UnitTest.h"
//#include "BlockChain.h"
#include "MockHsm.h"
#include "Asset.h"
#include "Transaction.h"
#include "Account.h"
#include "Key.h"
#include "Payment.h"
#include "ServerInfo.h"
#include "Order.h"

using namespace std;  

#define HTTPD_SERVER_PORT   80
#define HTTPD_MAX_REQ_LENGTH   1023
#define HTTPD_MAX_HDR_LENGTH   255
#define HTTPD_MAX_FNAME_LENGTH   127
#define HTTPD_MAX_DNAME_LENGTH   127

#define DEBUG_LOG 1

const char* ECHO_SERVER_ADDRESS = "192.168.31.185";
const int ECHO_SERVER_PORT = 10003;

Serial uart(USBTX, USBRX);

//SDFileSystem sd(p5, p6, p7, p8, "sd"); // LPC1768 MBD2PMD
//SDFileSystem sd(P0_18, P0_17, P0_15, P0_16, "sd"); // Seeeduino Arch Pro SPI2SD
//SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // K64F

EthernetInterface eth;
TCPSocketServer server;
TCPSocketConnection client;
TCPSocketConnection my_client;

char buffer[HTTPD_MAX_REQ_LENGTH+1];
char httpHeader[HTTPD_MAX_HDR_LENGTH+1];
char fileName[HTTPD_MAX_FNAME_LENGTH+1];
char dirName[HTTPD_MAX_DNAME_LENGTH+1];
char *uristr;
char *eou;
char *qrystr;

FILE *fp;
int rdCnt;

// function declation
int test_socket_client(void);
int socket_init();
int socket_fini();


void test_uuid()
{
    char pUUID[128] = {0};
    getUniqueIDAsStr(pUUID);
    printf("CPUID = %s \n",pUUID);
    //printUniqueId(uart);
}

int test_MockHsm()
{
    MockHsm mh;
    mh.setAlias("t_key_6");
    cout<<mh.getAlias()<<endl;
    cout<<mh.createKey()<<endl;
    cout<< mh.listKeys() <<endl;
    return 0;
}

int test_Asset()
{
    Asset asset;
    asset.setAlias("t_asset_6");

    cout<< asset.createAsset() << endl;
    cout<< asset.listAssets() << endl;
    
    
    return 0;
}

int test_Account()
{
    Key key;
    key.setAlias("t_key");
    key.listKeys();

    Account act(key);
    act.setAlias("t_acc_8");
    act.createAccount();
    act.listAccounts();

    return 0;
}

int test_transaction(string type)
{
    Transaction ts;
    //cout << ts.buildTransaction() << endl;
    ts.buildTransaction(type);
    ts.signTransaction();
    ts.submitTransaction();
    ts.listTransactions();
    return 0;
}

int test_transaction()
{
    vector<Actions> vActions;
    Actions act;
    MbedJSONValue reference_data;

    act.accounts_alias = "t_acc_1";
    act.amount = 51;
    act.asset_alias = "t_asset";
    act.reference_data = reference_data;
    act.type = "spend_account";
    vActions.push_back(act);

    Actions act1 = {"t_acc_2",  "t_asset", 49, reference_data, "spend_account"  };
    Actions act2 = {"tom",      "t_asset", 80, reference_data, "control_account"};
    Actions act3 = {"Jerry",    "t_asset", 20, reference_data, "control_account"};

    vActions.push_back(act1);
    vActions.push_back(act2);
    vActions.push_back(act3);
 printf("=============2========\r\n");
    Transaction ts;
    ts.buildTransaction(vActions);
    ts.signTransaction();
    ts.submitTransaction();
    ts.listTransactions();

    return 0;
}


// cover int to string
void int2str(const int &int_temp,string &string_temp)  
{  
    stringstream stream;  
    stream<<int_temp;  
    string_temp=stream.str();   //此处也可以用 stream>>string_temp  
}

// cover string to int
void str2int(int &int_temp,const string &string_temp)  
{  
    stringstream stream(string_temp);  
    stream>>int_temp;  
}  

// cover string to long
void str2long(long &long_temp,const string &string_temp)  
{  
    stringstream stream(string_temp);  
    stream>>long_temp;  
}  


long sd_account()
{
    string balance = "";
    Account act;
    balance = act.getBalance();
    cout << "Extract json content from http message:"<<balance.c_str() << endl;
    if (balance.empty())
    {
        return -1;
    }
    // decode content json 
    MbedJSONValue objJson;
    //string err = parse(objJson, balance.c_str());
    //int iLedger = objJson["ledger"].get<int>();
    //bool bSuccess = objJson["success"].get<bool>();
    //int iCurrenciesNum = objJson["balances"].size();
    /*for (int i = 0;i < iCurrenciesNum; i++)
    {
        string value = objJson["balances"][i]["value"].get<string>();
        string currency = objJson["balances"][i]["currency"].get<string>();
        string counterparty = objJson["balances"][i]["counterparty"].get<string>();
        cout << i << ":" << currency << "--" << value << "--" << counterparty << endl;
    }*/
    string err = act.getParseMbedJson(objJson, balance.c_str());
    int iLedger = act.getLedger(objJson);
    bool bSuccess = act.getRequestRet(objJson);
    int iCurrenciesNum = act.getBalanceSize(objJson,"balances");
    char pLedger[16] = {0};
    sprintf(pLedger, "%d", iLedger);
    cout<<"Ledger is :"<<pLedger<<endl;
    long sda = 0;
    for (int i = 0; i < iCurrenciesNum; i++)
    {
        string value = act.getBalanceArray(objJson, "balances", i, "value");
        string currency = act.getBalanceArray(objJson, "balances", i, "currency");
        string counterparty = act.getBalanceArray(objJson, "balances", i, "counterparty");
        cout << "The " << i <<" record:" << endl << "value:" << value << endl << "currency:"<<currency<<endl 
            << "counterparty:" << counterparty << endl;
        if("SDA" == currency) str2long(sda,value);
    }
    return sda;
}

int sd_wallet()
{
    
    string strJson = "";
    cout<<"sd_wallet func"<<endl;
    Account act;
    cout<<"act.getWallet()...begin"<<endl;
    strJson = act.getWallet ();
    cout<<"act.getWallet()...end"<<endl;
    cout << "Extract json content from http message:"<<strJson.c_str() << endl;
    if (strJson.empty())
    {
        return -1;
    }
    // decode content json 
    MbedJSONValue objJson;
//  string err = parse(objJson, strJson.c_str());
//  bool bSuccess = objJson["success"].get<bool>();
//  if (bSuccess)
//  {
//      string address = objJson["wallet"]["address"].get<string>();
//      string secret = objJson["wallet"]["secret"].get<string>();
//      cout << "wallet:" << address << "--" << secret << endl;
//  }
    string err = act.getParseMbedJson(objJson, strJson.c_str());
    bool bSuccess = act.getRequestRet(objJson);
    if (bSuccess)
    {
        string address1 = act.getKeyValue(objJson, "wallet", "address");
        string secret1 = act.getKeyValue(objJson, "wallet", "secret");
        cout << "address:" << address1 << endl << "secret:" << secret1 << endl;
    }

    return 0;
}

int sd_postpayment()//支付请求
{
    string strJson = "";
    Payment pay;
    MbedJSONValue mbJson;
    MbedJSONValue objJson;
    string secret = "sh7dqVn8mhg6BqGfAQyaYVUwK2zkR";
    string src_acc = "6ByxwCh2Lqwwr3pk6mh4GBb4bsqFz2zAKY";
    string dst_acc = "69Hu8QsnEZUP4f3AVYSW7rkpLVm6DAEq9y";
    string amount = "20";
    string MemoType = "memos";
    string MemoData = "memos";
    string strWallet = "6ByxwCh2Lqwwr3pk6mh4GBb4bsqFz2zAKY";
    string strUrl = "/v1/accounts/payments/";
    pay.SetJsonBody(mbJson, secret, src_acc, dst_acc, amount, MemoType, MemoData);
    strJson = pay.PostPayment(mbJson, strUrl, strWallet,"");
    if (strJson.empty())
    {
        return -1;
    }
    string err = pay.getParseMbedJson(objJson, strJson.c_str());
    bool bSuccess = pay.getRequestRet(objJson);
    if (bSuccess)
    {
        string hash = pay.getKeyValue(objJson, "hash");
        string status_url = pay.getKeyValue(objJson, "status_url");
        cout << "hash:" << hash << endl;
        cout << "status_url:" << status_url << endl;
    }
    return 0;
}

int sd_getpaymentinfo()
{
    Payment pay;
    MbedJSONValue objJson;
    string strJson = "";
    string strWallet = "69Hu8QsnEZUP4f3AVYSW7rkpLVm6DAEq9y";
    string strUrl = "/v1/accounts/payments/";
    string strHash = "EF252979355F2666486F69E9C96D137265214DE65B14E1136ECCDCE84F09AD11";
    strJson = pay.GetPaymentInfo(strUrl, strWallet, strHash);
    if (strJson.empty())
    {
        return -1;
    }
    string err = pay.getParseMbedJson(objJson, strJson.c_str());
    bool bSuccess = pay.getRequestRet(objJson);
    if (bSuccess)
    {
        string hash = pay.getKeyValue(objJson, "hash");
        string ledger = pay.getKeyValue(objJson, "ledger");
        string state = pay.getKeyValue(objJson, "state");
        string source_account = pay.getKeyValue(objJson, "source_account");
        string dst_account = pay.getKeyValue(objJson, "destination_account");
        string amount_cur = pay.getKeyValue(objJson, "amount", "currency");
        string value = pay.getKeyValue(objJson, "amount", "value");
        string amount_issuer = pay.getKeyValue(objJson, "amount", "issuer");
        string currency = pay.getKeyValue(objJson, "currency");
        string issuer = pay.getKeyValue(objJson, "issuer");
        string direction = pay.getKeyValue(objJson, "direction");
        string timestamp = pay.getKeyValue(objJson, "timestamp");
        string fee = pay.getKeyValue(objJson, "fee");
        cout << "hash:" << hash <<endl<<"ledger:" << ledger <<endl<< " state:" << state
            <<endl<< " source_account:" << source_account <<endl<< " dst_account:" << dst_account
            <<endl<< " amount_cur:" << amount_cur <<endl<< " value:" << value <<endl<< " amount_issuer:" << amount_issuer
            <<endl<< " currency:" << currency <<endl<< " issuer" << issuer <<endl<< " direction" << direction
            <<endl<< " timestamp:" << timestamp <<endl<< " fee" << fee <<endl;
        int iCurrenciesNum = pay.getBalanceSize(objJson, "memos");
        for (int i = 0; i < iCurrenciesNum; i++)
        {
            string memo_type = pay.getBalanceArray(objJson, "memos", i, "memo_type");
            string memo_data = pay.getBalanceArray(objJson, "memos", i, "memo_data");
            cout << i << ":" << memo_type << "--" << memo_data << endl;
        }
        
    }
    return 0;
}

int sd_gettransactions()
{
    Payment pay;
    MbedJSONValue objJson;
    string strJson = "";
    string strHash = "EF252979355F2666486F69E9C96D137265214DE65B14E1136ECCDCE84F09AD11";
    string strUrl = "/v1/transactions/";
    strJson = pay.GetPaymentInfo(strUrl,"", strHash);
    if (strJson.empty())
    {
        return -1;
    }
    string err = pay.getParseMbedJson(objJson, strJson.c_str());
    bool bSuccess = pay.getRequestRet(objJson);
    if (bSuccess)
    {
        string TransactionType = pay.getKeyValue(objJson, "transaction", "TransactionType");
        int Flags = pay.getKeyValueInt(objJson, "transaction", "Flags");
        int Sequence = pay.getKeyValueInt(objJson, "transaction", "Sequence");
        int LastLedgerSequence = pay.getKeyValueInt(objJson, "transaction", "LastLedgerSequence");
        string Amount = pay.getKeyValue(objJson, "transaction", "Amount");
        string Fee = pay.getKeyValue(objJson, "transaction", "Fee");
        string SigningPubKey = pay.getKeyValue(objJson, "transaction", "SigningPubKey");
        string TxnSignature = pay.getKeyValue(objJson, "transaction", "TxnSignature");
        string Account = pay.getKeyValue(objJson, "transaction", "Account");
        string Destination = pay.getKeyValue(objJson, "transaction", "Destination");
        int iCurrenciesNum = pay.getBalanceSize(objJson,"transaction","Memos");
//      for (int i = 0; i < iCurrenciesNum; i++)
//      {
//          string MemoType = pay.getBalanceArray(objJson, "transaction", "Memos", "Memo", i, "MemoType");
//          string MemoData = pay.getBalanceArray(objJson, "transaction", "Memos", "Memo", i, "MemoData");
//          string parsed_memo_type = pay.getBalanceArray(objJson, "transaction", "Memos", "Memo", i, "parsed_memo_type");
//          cout << i << ":" << MemoType << "--" << MemoData << "--" << parsed_memo_type << endl;
//      }
        int date = pay.getKeyValueInt(objJson, "transaction", "date");
        string hash = pay.getKeyValue(objJson, "transaction", "hash");
        int inLedger = pay.getKeyValueInt(objJson, "transaction", "inLedger");
        int ledger_index = pay.getKeyValueInt(objJson, "transaction", "ledger_index");
        bool validated = pay.getKeyValueBool(objJson, "transaction", "validated");
        cout<<"TransactionType:"<<TransactionType<<endl<<"Amount:"<<Amount<<endl<<"Fee:"<<Fee<<endl
        <<"SigningPubKey:"<<SigningPubKey<<endl<<"TxnSignature:"<<TxnSignature<<endl
        <<"Account:"<<Account<<endl<<"Destination:"<<Destination<<endl;
    }
    return 0;
}

int sd_getpaymenthistory()
{
    Payment pay;
    MbedJSONValue objJson;
    MbedJSONValue mbJson;
    string strJson = "";
    string strUrl = "/v1/accounts/payments/";
    string strWallet = "6ByxwCh2Lqwwr3pk6mh4GBb4bsqFz2zAKY";
    string src_acc = "6ByxwCh2Lqwwr3pk6mh4GBb4bsqFz2zAKY";
    string dst_acc = "69Hu8QsnEZUP4f3AVYSW7rkpLVm6DAEq9y";
    string direction = "incoming";
    int start_ledger = 1;
    int end_ledger = 10000;
    int per_page = 10;
    int page = 1;
    pay.SetJsonBody(mbJson, src_acc, dst_acc, direction, start_ledger, end_ledger, per_page, page);
    strJson = pay.PostPayment(mbJson, strUrl, strWallet, "");
    if (strJson.empty())
    {
        return -1;
    }
    string err = pay.getParseMbedJson(objJson, strJson.c_str());
    bool bSuccess = pay.getRequestRet(objJson);
    if (bSuccess)
    {
        int iCurrenciesNum = pay.getBalanceSize(objJson,"payments");
        for (int i = 0; i < iCurrenciesNum; i++)
        {
            string hash = pay.getBalanceArray(objJson, "payments", i, "hash");
            string ledger = pay.getBalanceArray(objJson, "payments", i, "ledger");
            string source_account = pay.getBalanceArray(objJson, "payments", i, "source_account");
            string destination_account = pay.getBalanceArray(objJson, "payments", i, "destination_account");
            string currency = pay.getBalanceArray(objJson, "payments", "amount", i,currency);
            string value = pay.getBalanceArray(objJson, "payments", "amount", i, value);
            string issuer = pay.getBalanceArray(objJson, "payments", "amount", i, issuer);
            string direction = pay.getBalanceArray(objJson, "payments", i, "direction");
            string timestamp = pay.getBalanceArray(objJson, "payments", i, "timestamp");
            string fee = pay.getBalanceArray(objJson, "payments", i, "fee");
            int iCurrenciesNum = pay.getBalanceSize(objJson, "transaction", "Memos");
            for (int j = 0; j < iCurrenciesNum; j++)
            {
                string memo_type = pay.getBalanceArray(objJson, "transaction", "memos", i, "memo_type");
                string memo_data = pay.getBalanceArray(objJson, "transaction", "memos", i, "memo_data");
                cout << i << ":" << memo_type << "--" << memo_data << endl;
            }
            cout<<"hash:"<<hash<<endl<<"ledger:"<<ledger<<endl<<"source_account:"<<source_account<<endl
            <<"destination_account:"<<destination_account<<endl<<"currency:"<<currency<<endl<<"timestamp:"
            <<timestamp<<endl;
        }
    }
    return 0;
}

int sd_getdefaultfee()
{
    ServerInfo serInfo;
    MbedJSONValue objJson;
    string strJson = "";
    string strUrl = "/v1/transaction-fee";
    strJson = serInfo.GetPaymentInfo(strUrl, "", "");
    if (strJson.empty())
    {
        return -1;
    }
    string err = serInfo.getParseMbedJson(objJson, strJson.c_str());
    bool bSuccess = serInfo.getRequestRet(objJson);
    if (bSuccess)
    {
        string fee = serInfo.getKeyValue(objJson, "fee");
        cout << "fee:" << fee << endl;
    }
    return 0;
}

int sd_getserverinfo()
{
    ServerInfo serInfo;
    MbedJSONValue objJson;
    string strJson = "";
    string strUrl = "/v1/server";
    strJson = serInfo.GetPaymentInfo(strUrl, "", "");
    if (strJson.empty())
    {
        return -1;
    }
    string err = serInfo.getParseMbedJson(objJson, strJson.c_str());
    bool bSuccess = serInfo.getRequestRet(objJson);
    if (bSuccess)
    {
        string complete_ledgers = serInfo.getKeyValue(objJson, "sdchaind_server_status", "complete_ledgers");
        string server_state = serInfo.getKeyValue(objJson, "sdchaind_server_status", "server_state");
        int reserve_base_sda = serInfo.getKeyValueInt(objJson, "sdchaind_server_status", "reserve_base_sda");
        cout << "complete_ledgers:" << complete_ledgers <<endl<< "server_state:" << server_state<<endl << "reserve_base_sda:" << reserve_base_sda << endl;
    }
    return 0;
}

int sd_getserverconnected()
{
    ServerInfo serInfo;
    MbedJSONValue objJson;
    string strJson = "";
    string strUrl = "/v1/server/connected";
    strJson = serInfo.GetPaymentInfo(strUrl, "", "");
    if (strJson.empty())
    {
        return -1;
    }
    string err = serInfo.getParseMbedJson(objJson, strJson.c_str());
    bool bSuccess = serInfo.getRequestRet(objJson);
    if (bSuccess)
    {
        bool connected = serInfo.getKeyValueBool(objJson, "connected");
        if(connected)
        {cout<<"server is running"<<endl;}
        else
        {cout<<"server  stopped"<<endl;}
    }
    return 0;
}

int sd_queryorderlist()
{
    Order orderInfo;
    MbedJSONValue objJson;
    string strJson = "";
    string strUrl = "/v1/accounts/orders/";
    string strWallet = "6ByxwCh2Lqwwr3pk6mh4GBb4bsqFz2zAKY";
    strJson = orderInfo.GetPaymentInfo(strUrl, strWallet, "");
    if (strJson.empty())
    {
        return -1;
    }
    string err = orderInfo.getParseMbedJson(objJson, strJson.c_str());
    bool bSuccess = orderInfo.getRequestRet(objJson);
    if (bSuccess)
    {
        int  ledger = objJson["ledger"].get<int>();
        bool validated = orderInfo.getKeyValueBool(objJson, "validated");
        int iCurrenciesNum = orderInfo.getBalanceSize(objJson, "orders");
        for (int i = 0; i < iCurrenciesNum; i++)
        {
            string type = orderInfo.getBalanceArray(objJson, "orders", i, "type");
            string currency_gets = orderInfo.getBalanceArray(objJson, "orders","taker_gets",i,"currency");
            string value_gets = orderInfo.getBalanceArray(objJson, "orders", "taker_gets", i, "value");
            string counterparty_gets = orderInfo.getBalanceArray(objJson, "orders", "taker_gets", i, "counterparty");
            string currency_pays = orderInfo.getBalanceArray(objJson, "orders", "taker_pays", i, "currency");
            string value_pays = orderInfo.getBalanceArray(objJson, "orders", "taker_pays", i, "value");
            string counterparty_pays = orderInfo.getBalanceArray(objJson, "orders", "taker_pays", i, "counterparty");
            cout << "type:" << type <<endl<< "currency_gets:" << currency_gets <<endl<< "value_gets:" << value_gets<<endl
                << "counterparty_gets:" << counterparty_gets <<endl<< "currency_pays:" << currency_pays<<endl
                << "value_pays:" << value_pays <<endl<< "counterparty_pays:" << counterparty_pays << endl;
        }
        cout << "ledger:" << ledger <<endl<< "validated:" << validated << endl;
    }
    return 0;
}

int sd_commitorder()
{
    Order orderCommit;
    MbedJSONValue objJson;
    MbedJSONValue mbJson;
    string strJson = "";
    string strUrl = "/v1/accounts/orders/";
    string strWallet = "6ByxwCh2Lqwwr3pk6mh4GBb4bsqFz2zAKY";
    string secret = "sh7dqVn8mhg6BqGfAQyaYVUwK2zkR";
    orderCommit.SetJsonBody(mbJson, secret, "buy", "SDA", "", "4", "CNY", "6UPd52jHtu1d88nc3S3WeroACFQpKfybhU", "22");
    strJson = orderCommit.PostPayment(mbJson, strUrl, strWallet, "");
    if (strJson.empty())
    {
        return -1;
    }
    string err = orderCommit.getParseMbedJson(objJson, strJson.c_str());
    bool bSuccess = orderCommit.getRequestRet(objJson);
    if (bSuccess)
    {
        string account = orderCommit.getKeyValue(objJson, "order", "account");
        string currency_g = orderCommit.getKeyValue(objJson, "taker_gets", "currency");
        string value_g = orderCommit.getKeyValue(objJson, "taker_gets", "value");
        string counterparty_g = orderCommit.getKeyValue(objJson, "taker_gets", "counterparty");
        string currency_p = orderCommit.getKeyValue(objJson, "taker_pays", "currency");
        string value_p = orderCommit.getKeyValue(objJson, "taker_pays", "value");
        string counterparty_p = orderCommit.getKeyValue(objJson, "taker_pays", "counterparty");
        string fee = orderCommit.getKeyValue(objJson, "order", "fee");
        string type = orderCommit.getKeyValue(objJson, "order", "type");
        int sequence = orderCommit.getKeyValueInt(objJson, "order","sequence");
        string hash = orderCommit.getKeyValue(objJson, "hash");
        int ledger = orderCommit.getLedger(objJson);
        string state = orderCommit.getKeyValue(objJson, "state");
        cout<<"account:"<<account<<endl<<"fee:"<<fee<<endl<<"hash:"<<hash<<endl<<"state:"<<state<<endl;
    }
    return 0;
}

int sd_deleteorder()
{
    Order orderCommit;
    MbedJSONValue objJson;
    MbedJSONValue mbJson;
    MbedJSONValue val;
    string strJson = "";
    string strUrl = "/v1/accounts/orders/";
    string strWallet = "6ByxwCh2Lqwwr3pk6mh4GBb4bsqFz2zAKY";
    string strNum = "1234";
    val["secret"] = "sh7dqVn8mhg6BqGfAQyaYVUwK2zkR";
    strJson = orderCommit.PostOrder(val, strUrl, strWallet, strNum);
    if (strJson.empty())
    {
        return -1;
    }
    string err = orderCommit.getParseMbedJson(objJson, strJson.c_str());
    bool bSuccess = orderCommit.getRequestRet(objJson);
    if (bSuccess)
    {
        string account = orderCommit.getKeyValue(objJson, "order", "account");
        string fee = orderCommit.getKeyValue(objJson, "order", "fee");
        string offer_sequence = orderCommit.getKeyValue(objJson, "order", "offer_sequence");
        string sequence = orderCommit.getKeyValue(objJson, "order", "sequence");
        string hash = orderCommit.getKeyValue(objJson, "hash");
        string ledger = orderCommit.getKeyValue(objJson, "ledger");
        string state = orderCommit.getKeyValue(objJson, "state");
        cout << "account:" << account <<endl<< "fee:" << fee <<endl<< "offer_sequence:" << offer_sequence<<endl
            << "sequence:" << sequence <<endl<< "hash:" << hash <<endl<<"ledger:" << ledger <<endl<< "state:" << state << endl;
    }
    return 0;
}

int sd_queryorderdetailed()
{
    cout << "call sd_queryorderdetailed begin" << endl;
    Order orderInfo;
    MbedJSONValue objJson;
    string strJson = "";
    string strUrl = " /v1/accounts/orders/";
    string strWallet = "6ByxwCh2Lqwwr3pk6mh4GBb4bsqFz2zAKY";
    string hash = "EF252979355F2666486F69E9C96D137265214DE65B14E1136ECCDCE84F09AD11";
    strJson = orderInfo.GetPaymentInfo(strUrl, strWallet,hash);
    if (strJson.empty())
    {
        cout << "call sd_queryorderdetailed exception quit" << endl;
        return -1;
    }
    string err = orderInfo.getParseMbedJson(objJson, strJson.c_str());
    bool bSuccess = orderInfo.getRequestRet(objJson);
    if (bSuccess)
    {
        string hash = orderInfo.getKeyValue(objJson, "hash");
        int ledger = objJson["ledger"].get<int>();
        int iBalanceNum = orderInfo.getBalanceSize(objJson, "balance_changes");
        for (int i = 0; i < iBalanceNum; i++)
        {
            string counterparty = orderInfo.getBalanceArray(objJson, "balance_changes", i, "counterparty");
            cout<<"counterparty:"<<counterparty<<endl;
        }
        int iOrderChangesNum = orderInfo.getBalanceSize(objJson, "order_changes");
        for (int j = 0; j < iOrderChangesNum; j++)
        {
            string currency_gets = orderInfo.getBalanceArray(objJson, "order_changes", "taker_gets", j, "currency");
            cout<<"currency_gets:"<<currency_gets<<endl;
        }
        cout<<"hash:"<<hash<<endl;

    }
    cout << "call sd_queryorderdetailed end" << endl;
    return 0;
}


int socket_init()
{
    int ret = 0;
    // EthernetInterface eth;
    printf("Initializing Ethernet\n");
    ret = eth.init(); //Use DHCP
    //eth.init("192.168.31.186", "255.255.255.0", "192.168.31.1"); //Use static ip
    printf("Connecting\n");
    ret = eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    return ret;
}

int socket_fini()
{
    return eth.disconnect();  
}

int test_socket_client(void)
{
    TCPSocketConnection socket;
    while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }
    printf("Connected to Server at %s\n",ECHO_SERVER_ADDRESS);
    
    // Send message to server
    char hello[] = "Hello World";
    printf("Sending  message to Server : '%s' \n",hello);
    socket.send_all(hello, sizeof(hello) - 1);
    
    // Receive message from server
    char buf[256];
    int n = socket.receive(buf, 256);
    buf[n] = '\0';
    printf("Received message from server: '%s'\n", buf);
    
    // Clean up
    socket.close();
    
    return 0;
}

/*
void get_file(char* uri)
{
    uart.printf("get_file %s\n", uri);
    char *lstchr = strrchr(uri, NULL) -1;
    if ('/' == *lstchr) {
        uart.printf("Open directory /sd%s\n", uri);
        *lstchr = 0;
        sprintf(fileName, "/sd%s", uri);
        DIR *d = opendir(fileName);
        if (d != NULL) {
            sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            sprintf(httpHeader,"<html><head><title>Directory Listing</title></head><body><h1>%s Directory Listing</h1><ul>", uri);
            client.send(httpHeader,strlen(httpHeader));
            struct dirent *p;
            while((p = readdir(d)) != NULL) {
                sprintf(dirName, "%s/%s", fileName, p->d_name);
                uart.printf("%s\n", dirName);
                DIR *subDir = opendir(dirName);
                if (subDir != NULL) {
                    sprintf(httpHeader,"<li><a href=\"./%s/\">%s/</a></li>", p->d_name, p->d_name);
                } else {
                    sprintf(httpHeader,"<li><a href=\"./%s\">%s</a></li>", p->d_name, p->d_name);
                }
                client.send(httpHeader,strlen(httpHeader));
            }
        }
        closedir(d);
        uart.printf("Directory closed\n");
        sprintf(httpHeader,"</ul></body></html>");
        client.send(httpHeader,strlen(httpHeader));
    } else {
        sprintf(fileName, "/sd%s", uri);
        fp = fopen(fileName, "r");
        if (fp == NULL) {
            uart.printf("File not found\n");
            sprintf(httpHeader,"HTTP/1.1 404 Not Found \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            client.send(uri,strlen(uri));
        } else {
            uart.printf("Sending: header");
            sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            uart.printf(" file");
            while ((rdCnt = fread(buffer, sizeof( char ), 1024, fp)) == 1024) {
                client.send(buffer, rdCnt);
                uart.printf(".");
            }
            client.send(buffer, rdCnt);
            fclose(fp);
            uart.printf("done\n");
        }
    }
}

int main_1 (void)
{
//    Serial Interface eth;
    uart.baud(115200);
    uart.printf("Initializing\n");

//    Check File System
    uart.printf("Checking File System\n");
    DIR *d = opendir("/sd/");
    if (d != NULL) {
        uart.printf("SD Card Present\n");
    } else {
        uart.printf("SD Card Root Directory Not Found\n");
    }

//    EthernetInterface eth;
    uart.printf("Initializing Ethernet\n");
    //eth.init(); //Use DHCP
    eth.init("192.168.31.186", "255.255.255.0", "192.168.31.1"); //Use  
    uart.printf("Connecting\n");
    eth.connect();
    uart.printf("IP Address is %s\n", eth.getIPAddress());
    
    //test socket client
    //my_client.connect("192.168.31.185",10003);
    //my_client.send_all("hello world",11);
    
     TCPSocketConnection socket;
    while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) {
        uart.printf("Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }
    uart.printf("Connected to Server at %s\n",ECHO_SERVER_ADDRESS);
    
    // Send message to server
    char hello[] = "Hello World";
    uart.printf("Sending  message to Server : '%s' \n",hello);
    socket.send_all(hello, sizeof(hello) - 1);
    
    // Receive message from server
    char buf[256];
    int n = socket.receive(buf, 256);
    buf[n] = '\0';
    uart.printf("Received message from server: '%s'\n", buf);
    
    // Clean up
    socket.close();
    ////////////////////////////////////////////////////////////////////////////

//    TCPSocketServer server;
    server.bind(HTTPD_SERVER_PORT);
    server.listen();
    uart.printf("Server Listening\n");

    while (true) {
        uart.printf("\nWait for new connection...\r\n");
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        my_client.send_all("hello world",11);

        uart.printf("Connection from: %s\r\n", client.get_address());
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            uart.printf("Recieved Data: %d\r\n\r\n%.*s\r\n",n,n,buffer);
            if (n >= 1024) {
                sprintf(httpHeader,"HTTP/1.1 413 Request Entity Too Large \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                client.send(httpHeader,strlen(httpHeader));
                client.send(buffer,n);
                break;
            } else {
                buffer[n]=0;
            }
            if (!strncmp(buffer, "GET ", 4)) {
                uristr = buffer + 4;
                eou = strstr(uristr, " ");
                if (eou == NULL) {
                    sprintf(httpHeader,"HTTP/1.1 400 Bad Request \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                    client.send(httpHeader,strlen(httpHeader));
                    client.send(buffer,n);
                } else {
                    *eou = 0;
                    get_file(uristr);
                }
            }
        }

        client.close();
    }
}
*/

int main_2() {
    //    Serial Interface eth;
    uart.baud(115200);
    uart.printf("Initializing\n");
    
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("\nClient IP Address is %s\n", eth.getIPAddress());
    
    // Connect to Server
    TCPSocketConnection socket;
    while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }
    printf("Connected to Server at %s\n",ECHO_SERVER_ADDRESS);
    
    // Send message to server
    char hello[] = "Hello World";
    printf("Sending  message to Server : '%s' \n",hello);
    socket.send_all(hello, sizeof(hello) - 1);
    
    // Receive message from server
    char buf[256];
    int n = socket.receive(buf, 256);
    buf[n] = '\0';
    printf("Received message from server: '%s'\n", buf);
    
    // Clean up
    socket.close();
    eth.disconnect();
    
    while(true) {}
}

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);

int main(void)
{
    printf("main start\n");
    
   // test_uuid();

    
    socket_init();
   
 //   cout<<"**************************GET NEW WALLET****************************"<<endl;
 //   sd_wallet();
 //   wait(2);
    cout<<"**************************GET ACCOUNT BALANCE************************"<<endl;
    while(1)
    {
        long balance = sd_account();
        wait(2);
        if(balance > 2000000)
        {
            myled1 = 1;
            myled2 = 0;
            myled3 = 0;
        }
        else
        {
            myled1 = 0;
            myled2 = 1;
            myled3 = 0;
        }        
    }
    
 /*   
    cout<<"*************************POST PAYMENT REQUEST********************"<<endl;
    sd_postpayment();
    wait(2);
    cout<<"*************************GET PAYMENT INFO****************"<<endl;
    sd_getpaymentinfo();
    wait(2);
    cout<<"*************************GET TRANSACTIONS INFO***********"<<endl;
    sd_gettransactions();
    wait(2);
    cout<<"*************************GET PAYMENT HISTORY*****************"<<endl;
    sd_getpaymenthistory();
    wait(2);
    cout<<"*************************GET DEFAULT FEE**********************"<<endl;
    sd_getdefaultfee();
    wait(2);
    cout<<"*************************GET SERVER INFO******************"<<endl;
    sd_getserverinfo();
    wait(2);
    cout<<"*************************GET SERVER CONNECTED******************"<<endl;
    sd_getserverconnected();
    wait(2);
    cout<<"*************************GET ORDER LIST********************"<<endl;
    sd_queryorderlist();
    wait(2);
    cout<<"*************************POST ORDER INFO********************"<<endl;
    sd_commitorder();
    wait(2);
    cout<<"*************************DELETE ORDER INFO********************"<<endl;
    sd_deleteorder();
    wait(2);
    cout<<"*************************GET ORDER DETAILED*******************"<<endl;
    sd_queryorderdetailed();

*/

    //char isContinue = 'y';
   // do
    //{
       //tring type = "spend_account";
        //string type = "issue";
        //test_transaction(type);
       //est_transaction();
       //rintf("=============5========\n");
   // }while(1);
    //}while (isContinue = getch() != 'q');
    
    
    //test_socket_client();
    
    socket_fini();
    
    printf("main end\n");
    return 0;
}