#include "adi_sense_1000_lut_data.h"
#include "adi_sense_1000_sensor_types.h"

/*
 * The following example illustrates how individual tables can be declared, and
 * later assembled into a complete LUT data structure using
 * adi_sense_1000_AssembleLutData().  That LUT data structure can then be
 * written to the ADI Sense 1000 device using adi_sense_1000_SetLutData().
 */


/*
 * The following table provide linearisation data for a 4-wire bridge sensor
 * identified with the ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_1_DEF_L2
 * sensor type.  The Look-Up Table provided maps a range of input (X)
 * values to a corresponding range of output (Y) values.  In this example,
 * the bridge sensor input in millivolts is effectively translated to volts.
 */
 ADI_SENSE_1000_LUT_DESCRIPTOR lc0 = {
    .geometry = ADI_SENSE_1000_LUT_GEOMETRY_NES_1D,
    .equation = ADI_SENSE_1000_LUT_EQUATION_LUT,
    .dir = ADI_SENSE_1000_LUT_TC_DIRECTION_FORWARD,
    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_1_DEF_L2,
    .dataType = ADI_SENSE_1000_LUT_DATA_TYPE_FLOAT32,
    .length = 0, /* Filled by adi_sense_1000_AssembleLutData() */
    .crc16 = 0   /* Filled by adi_sense_1000_AssembleLutData() */
};
ADI_SENSE_1000_LUT_1D_NES lc0Data = {
   .nElements = 9,
    .lut = {
        -3300.0f, /* x(min) */
        3.405f,
        4.38f,
        5.33f,
        6.02f,
        6.87f,
        8.41f,
        9.54f,
        +3300.0f, /* x(max) */
       -0.000001f,    /* y(min) */
        0.00f,
        2.5f,
        5.00f,
        7.5f,
        10.00f,
        12.5,
        15.00f,
        +50.0f,    /* y(max) */
    },
};

 
ADI_SENSE_1000_LUT_DESCRIPTOR lc1 = {
    .geometry = ADI_SENSE_1000_LUT_GEOMETRY_NES_1D,
    .equation = ADI_SENSE_1000_LUT_EQUATION_LUT,
    .dir = ADI_SENSE_1000_LUT_TC_DIRECTION_FORWARD,
    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_2_DEF_L2,
    .dataType = ADI_SENSE_1000_LUT_DATA_TYPE_FLOAT32,
    .length = 0, /* Filled by adi_sense_1000_AssembleLutData() */
    .crc16 = 0   /* Filled by adi_sense_1000_AssembleLutData() */
};
ADI_SENSE_1000_LUT_1D_NES lc1Data = {
      .nElements = 9,
    .lut = {
        -3300.0f, /* x(min) */
        -3.91f,
        -1.64f,
        1.2f,
        3.84f,
        7.17f,
        13.3f,
        17.96f,
        +3300.0f, /* x(max) */
     -0.000001f,    /* y(min) */
        0.00f,
        2.641f,
        5.07f,
        7.5f,
        10.0f,
        12.5f,
        15.0f,
        +50.0f, 
    },
};

ADI_SENSE_1000_LUT_DESCRIPTOR lc2 = {
    .geometry = ADI_SENSE_1000_LUT_GEOMETRY_NES_1D,
    .equation = ADI_SENSE_1000_LUT_EQUATION_LUT,
    .dir = ADI_SENSE_1000_LUT_TC_DIRECTION_FORWARD,
    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_3_DEF_L2,
    .dataType = ADI_SENSE_1000_LUT_DATA_TYPE_FLOAT32,
    .length = 0, /* Filled by adi_sense_1000_AssembleLutData() */
    .crc16 = 0   /* Filled by adi_sense_1000_AssembleLutData() */
};
ADI_SENSE_1000_LUT_1D_NES lc2Data = {
    .nElements = 9,
    .lut = {
        -3300.0f, /* x(min) */
        -1.08f,
        1.24f,
        3.39f,
        5.95f,
        8.38f,
        11.08f,
        14.79f,
        +3300.0f, /* x(max) */
        -0.000001f,    /* y(min) */
        0.00f,
        2.641f,
        5.07f,
        7.5f,
        10.0f,
        12.5f,
        15.0f,
        +50.0f, 
    },
};

ADI_SENSE_1000_LUT_DESCRIPTOR lc3 = {
    .geometry = ADI_SENSE_1000_LUT_GEOMETRY_NES_1D,
    .equation = ADI_SENSE_1000_LUT_EQUATION_LUT,
    .dir = ADI_SENSE_1000_LUT_TC_DIRECTION_FORWARD,
    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_4_DEF_L2,
    .dataType = ADI_SENSE_1000_LUT_DATA_TYPE_FLOAT32,
    .length = 0, /* Filled by adi_sense_1000_AssembleLutData() */
    .crc16 = 0   /* Filled by adi_sense_1000_AssembleLutData() */
};
ADI_SENSE_1000_LUT_1D_NES lc3Data = {
      .nElements = 9,
    .lut = {
        -3300.0f, /* x(min) */
        1.37f,
        5.28f,
        8.64f,
        12.35f,
        15.09f,
        18.12f,
        20.02f,
        +3300.0f, /* x(max) */
          -0.000001f,    /* y(min) */
        0.00f,
        2.641f,
        5.07f,
        7.5f,
        10.0f,
        12.5f,
        15.0f,
        +50.0f, 
    },
};
 ADI_SENSE_1000_LUT_DESCRIPTOR lc4 = {
    .geometry = ADI_SENSE_1000_LUT_GEOMETRY_NES_1D,
    .equation = ADI_SENSE_1000_LUT_EQUATION_LUT,
    .dir = ADI_SENSE_1000_LUT_TC_DIRECTION_FORWARD,
    .sensor = ADI_SENSE_1000_ADC_SENSOR_VOLTAGE_PRESSURE_1_DEF_L2,
    .dataType = ADI_SENSE_1000_LUT_DATA_TYPE_FLOAT32,
    .length = 0, /* Filled by adi_sense_1000_AssembleLutData() */
    .crc16 = 0   /* Filled by adi_sense_1000_AssembleLutData() */
};
ADI_SENSE_1000_LUT_1D_NES lc4Data = {
   .nElements = 7,
    .lut = {
         -3300.0f, /* y(min) */
         500.0f,
         1000.0f,
         2000.0f,
         3000.0f,
         4000.0f,
        +5000.0f, /* y (max) */
          -3300.0f, /* x(min) */
        1750.0f,
        2250.0f,
        2750.0f,
        3050.0f,
        3250.0f,
        +3300.0f, /* x(max) */
    },
};


/*
 * The following variables can be passed as parameters to
 * adi_sense_1000_AssembleLutData()
 */
ADI_SENSE_1000_LUT_DESCRIPTOR *sample_lut_desc_list[] = {
    &lc0,
    &lc1,
    &lc2,
    &lc3,   
    &lc4, 

};

ADI_SENSE_1000_LUT_TABLE_DATA *sample_lut_data_list[] = {
    (ADI_SENSE_1000_LUT_TABLE_DATA *) &lc0Data,
    (ADI_SENSE_1000_LUT_TABLE_DATA *) &lc1Data,
    (ADI_SENSE_1000_LUT_TABLE_DATA *) &lc2Data,
    (ADI_SENSE_1000_LUT_TABLE_DATA *) &lc3Data, 
     (ADI_SENSE_1000_LUT_TABLE_DATA *) &lc4Data, 
};

unsigned sample_lut_num_tables =
    (sizeof(sample_lut_desc_list) / sizeof(sample_lut_desc_list[0]));

