#include "mbed.h"

DigitalOut redLed( LED_RED ); // Led used to signal errors
DigitalOut greenLed( LED_GREEN );
DigitalOut spiSS( PTD0 ); // Slave select is handled by GPIO
Serial PC (USBTX, USBRX);
 
int main() {
    redLed = 1;
    greenLed = 1;
    // Create SPI master instance, 8bit, CPOL=0, CPHA=1, 100kHz
    SPI spiMaster( PTD2, PTD3, PTD1 ); // mosi, miso, sclk
    spiMaster.format( 8, 1 );
    spiMaster.frequency( 100000 );
    
    PC.baud(115200);
    // Deselect slave
    spiSS = 1;
    // Forever
    wait(1);
    
    while( 1 ) {
        int rx = 0;
        uint8_t data[256];
        // Burst write
        spiSS = 0;
        spiMaster.write( '#' );
        spiMaster.write( 0x07 ); // write RAM burst
        spiMaster.write( 0x01 ); // AA1
        spiMaster.write( 0x02 ); // AA2
        spiMaster.write( 0x03 ); // AA3
        
        
        for(int i = 0; i < 128 ; i++ )
        {
            spiMaster.write( 2*i );   //DD1
            spiMaster.write( 2*i+1 );   //DD2
        
            rx = 0;
            
            while(rx != '@')
            {
                rx = spiMaster.write( 0x55 );
            }
            
            rx = 0;
        }
        
        spiMaster.write( '#' ); // fine burst
        
        spiSS = 1;
        
        wait(1);
        
        spiSS = 0;
        spiMaster.write( '#' );
        spiMaster.write( 0x05 ); // write RAM burst
        spiMaster.write( 0x01 ); // AA1
        spiMaster.write( 0x02 ); // AA2
        spiMaster.write( 0x03 ); // AA3
        
        
        for(int i = 0; i < 128; i++ )
        {        
            while(rx != '@')
            {
                rx = spiMaster.write( 0x55 );
            }
            
            rx = 0;

            data[2*i] = spiMaster.write( 0x55 );    //DD1
            data[2*i+1] = spiMaster.write( 0x55 );   //DD2
                       
        }
        
        spiMaster.write( '#' ); // fine burst
        
        spiSS = 1;
        
        wait(1);
                
        for(int i = 0; i < 128 ; i++)
        {
            PC.printf("%d..%d\r\n", data[2*i], data[2*i+1]);
        }    

        //viualizza sui led i valori letti
        for(int i = 0; i < 128; i++)
        {
            greenLed = 0;
            spiSS = 0;
            spiMaster.write( '#' );
            spiMaster.write( 0x02 );
            spiMaster.write( data[2*i] );
            
            wait(0.25);
            greenLed = 1;
            wait(0.25);
            
            greenLed = 0;
            spiMaster.write( '#' );
            spiMaster.write( 0x02 );
            spiMaster.write( data[2*i+1] );
            spiSS = 1;
            
            wait(0.25);
            greenLed = 1;
            wait(0.25);
                    
        }
            
            wait(5);
    }
}