#include "mbed.h"

DigitalOut redLed( LED_RED ); // Led used to signal errors
DigitalOut spiSS( PTD0 ); // Slave select is handled by GPIO

int main() {
    redLed = 1;
    // Create SPI master instance, 8bit, CPOL=0, CPHA=1, 100kHz
    SPI spiMaster( PTD2, PTD3, PTD1 ); // mosi, miso, sclk
    spiMaster.format( 8, 1 );
    spiMaster.frequency( 10000 );
    // Deselect slave
    spiSS = 1;
    // Forever
    
    wait(1);
    while( 1 ) {
        int rx, dd1, dd2;
        // Single write
        spiSS = 0;
        spiMaster.write( '#' );
        spiMaster.write( 0x06 ); // write RAM
        spiMaster.write( 0x01 ); // AA1
        spiMaster.write( 0x02 ); // AA2
        spiMaster.write( 0x03 ); // AA3
        spiMaster.write( 0x11 ); // DD1
        spiMaster.write( 0x22 ); // DD2
        
        do{
            rx = spiMaster.write( 0x55 );
        }while( rx != '@' );
        rx = 0;
        
        spiSS = 1;
        wait( 0.01 );
        
        // Single Read
        spiSS = 0;
        spiMaster.write( '#' );
        spiMaster.write( 0x04 ); // read RAM
        spiMaster.write( 0x01 ); // AA1
        spiMaster.write( 0x02 ); // AA2
        spiMaster.write( 0x03 ); // AA3
        
        do{
            rx = spiMaster.write( 0x55 );
        }while( rx != '@' );
        rx = 0;
        
        dd1 = spiMaster.write( 0x55 );
        dd2 = spiMaster.write( 0x55 );
        
        spiSS = 1;
        
        if(( dd1 != 0x11 ) || ( dd2 != 0x22 )){
            redLed = 0;
        }
        
        spiSS = 0;
        spiMaster.write( '#' );
        spiMaster.write( 0x02 );
        spiMaster.write( dd1 );
        spiSS = 1;
        
        
        
        wait( 1 );
    }
}
