#include "mbed.h"

DigitalOut redLed( LED_RED ); // Led used to signal errors
DigitalOut spiSS( PTD0 ); // Slave select is handled by GPIO

int main() {
    redLed = 0;
    // Create SPI master instance, 8bit, CPOL=0, CPHA=1, 100kHz
    SPI spiMaster( PTD2, PTD3, PTD1 ); // mosi, miso, sclk
    spiMaster.format( 8, 1 );
    spiMaster.frequency( 10000 );
    // Deselect slave
    spiSS = 1;
    // Forever
    wait(1);
    
    while( 1 ) {
        int rx, dd1, dd2;
        // Burst write
        spiSS = 0;
        spiMaster.write( '#' );
        spiMaster.write( 0x07 ); // write RAM burst
        spiMaster.write( 0x01 ); // AA1
        spiMaster.write( 0x02 ); // AA2
        spiMaster.write( 0x03 ); // AA3
        
        
        for(int i = 0; i < 100; i++ ){
            spiMaster.write( i ); // DD1
            spiMaster.write( i+1 ); // DD2
            
            do{
                rx = spiMaster.write( 0x55 );
            }while( rx != '@' );
            rx = 0;
        }
        
        spiMaster.write( '#' );  // termina burst
        
        
        spiSS = 1;
        wait( 1 );
        
        // Burst Read
        spiSS = 0;
        spiMaster.write( '#' );
        spiMaster.write( 0x05 ); // burst read RAM
        spiMaster.write( 0x01 ); // AA1
        spiMaster.write( 0x02 ); // AA2
        spiMaster.write( 0x03 ); // AA3
        
        for(int i = 0; i < 100; i++ ){
            do{
                rx = spiMaster.write( 0x55 );
            }while( rx != '@' );
            rx = 0;
            
            dd1 = spiMaster.write( 0x55 );
            dd2 = spiMaster.write( 0x55 );
            
            //if( (dd1 == i) && (dd2 == (i+2))){
            //    redLed = 1;
            //}
            
            if(( dd1 != i ) or (dd2 != (i+1) )){
                redLed = 0;     // NON DEVE SBAGLIARE
                //wait( 0.5 );
            }
            redLed = 1;
            
            //redLed = 0;
            //wait( 0.5 );
        }
        
        spiSS = 1;
    }
}
