#include "mbed.h"
#include "MMA8451Q.h"
#include "I2C.h"
#include "SPI.h"
#include "DigitalIn.h"
#include "DigitalOut.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif

//--RELATIVI ALLA COMUNICAZIONE SPI------
PinName const mosi = PTD2; //mosi SPI1_mosi
PinName const miso = PTD3; //miso SPI1_miso
PinName const sck  = PTD1; //sck SPI1_sck
PinName const pcs0 = PTD0; //pcs0 SPI1_pcs0
//--RELATIVI ALLA COMUNICAZIONE SPI------

//instanzia e inizializza oggettto spi della classe SPI
SPI spi(mosi,miso,sck);
DigitalOut slave_select(pcs0,1); //inizializza slave-select
//-------------------------------------------------------                                             


#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void)
{
    
    //--setting delle impostazioni del SPI in base alle specifiche------------------    
    int bits = 8;
    int mode = 1;
    spi.format(bits,mode);//definisce formato spi con 16 bit e pol=0 e pha=1
    //di default la frequenza è 1MHz
    char command_wr=0x80; //comando per la scrittura (10000DDD), di default nella locazione DDD=000
    //int command_rd=0; //comando per la lettura (00000DDD), dib default nella locazione DDD=000
                        //non utilizzato !
    //--setting delle impostazioni della SPI come da specifiche------------------------
       
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);

    printf("MMA8451 ID: %d\n", acc.getWhoAmI());
    
    float   x_axis_norm,                            y_axis_norm,                            z_axis_norm;
    int     x_tens,             x_unit,             y_tens,             y_unit,             z_tens,             z_unit;
    char    x_tens_ascii,       x_unit_ascii,       y_tens_ascii,       y_unit_ascii,       z_tens_ascii,       z_unit_ascii;
    char    command_location;
    while (true) {
        float x_axis, y_axis, z_axis;
        x_axis = abs(acc.getAccX());
        y_axis = abs(acc.getAccY());
        z_axis = abs(acc.getAccZ());
        rled = 1.0f - x_axis;
        gled = 1.0f - y_axis;
        bled = 1.0f - z_axis;
        wait(0.1f);
        printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n", x_axis, y_axis, z_axis);
        
        
            //SCRIVO DATI SU DISPLAY A SETTE SEGMENTI DELLA SCHEDA DE2 MEDIANTE SPI
            //accelerazione sull'asse x
            x_axis_norm=x_axis*100;  // normalizzo tra [0 99]  
            x_tens = (int(x_axis_norm/10)); // ottengo le decine
            x_unit = (x_axis_norm-10*x_tens); // ottengo le unità
            x_tens_ascii = ( '0' + (x_tens)  ); // ottengo le decine in ASCII
            x_unit_ascii = ( '0' + (x_unit)  ); // ottengo le unità in ASCII
            //accelerazione sull'asse y
            y_axis_norm=y_axis*100;  // normalizzo tra [0 99] 
            y_tens = (int(y_axis_norm/10)); // ottengo le decine
            y_unit = (y_axis_norm-10*y_tens); // ottengo le unità
            y_tens_ascii = ( '0' + (y_tens)  ); // ottengo le decine in ASCII
            y_unit_ascii = ( '0' + (y_unit)  ); // ottengo le unità in ASCII   
            //accelerazione sull'asse z
            z_axis_norm=z_axis*100;  // normalizzo tra [0 99] 
            z_tens = (int(z_axis_norm/10)); // ottengo le decine
            z_unit = (z_axis_norm-10*z_tens); // ottengo le unità
            z_tens_ascii = ( '0' + (z_tens)  ); // ottengo le decine in ASCII
            z_unit_ascii = ( '0' + (z_unit)  ); // ottengo le unità in ASCII   
                      
            //stampo nella seriale componente x,y,z dell'accelereazione normailzzate tra 0 e 99
            printf("ax_norm: %1.2f, ay_norm: %1.2f, az_norm: %1.2f\n", x_axis_norm, y_axis_norm, z_axis_norm);
            //stampo nella seriale le decine delle componenti x,y,z dell'accelereazione normailzzate tra 0 e 99
            printf("ax_tens: %1.2d, ay_tens: %1.2d, az_tens: %1.2d\n", x_tens, y_tens, z_tens);
            //stampo nella seriale le unità delle componenti x,y,z dell'accelereazione normailzzate tra 0 e 99
            printf("ax_unit: %1.2d, ay_unit: %1.2d, az_unit: %1.2d\n", x_unit, y_unit, z_unit);
            //stampo nella seriale le decine in ascii delle componenti x,y,z dell'accelereazione normailzzate tra 0 e 99
            printf("ax_tens_ascii: %1.2c, ay_tens_ascii: %1.2c, az_tens_ascii: %1.2c\n", x_tens_ascii, y_tens_ascii, z_tens_ascii);
            //stampo nella seriale le unità in ascii delle componenti x,y,z dell'accelereazione normailzzate tra 0 e 99
            printf("ax_unit_ascii: %1.2c, ay_unit_ascii: %1.2c, az_unit_ascii: %1.2c\n", x_unit_ascii, y_unit_ascii, z_unit_ascii);
            
            //scrivo nei display i valori dell'accelerazione
            
            //componente x dell'accelarazione
            //scrivo codice ascii delle decine nel display nel display dedicato 
            //command_location = ( command_wr | loc_x_tens ) ; //1000 000 = 0x80
            command_location = 0x80;
            slave_select.write(0);
            spi.write(command_location);
            spi.write(x_tens_ascii);
            slave_select.write(1);
            //scrivo codice ascii delle unità nel display nel display dedicato 
            //command_location = ( command_wr | loc_x_unit ) ; //1000 001 = 0x81
            command_location = 0x81;
            slave_select.write(0);
            spi.write(command_location);
            spi.write(x_unit_ascii);
            slave_select.write(1);

            //componente y dell'accelarazione
            //scrivo codice ascii delle decine nel display nel display dedicato 
            //command_location = ( command_wr | loc_y_tens ); //1000 010 = 0x82
            command_location = 0x82;
            slave_select.write(0); //asserisco lo slave select attivo basso
            spi.write(command_location);
            spi.write(y_tens_ascii); 
            slave_select.write(1); //nego lo slave select attivo basso
            //scrivo codice ascii delle unità nel display nel display dedicato 
            //command_location = ( command_wr | loc_y_unit ); //1000 011 = 0x83
            command_location = 0x83;
            slave_select.write(0); //asserisco lo slave select attivo basso
            spi.write(command_location);
            spi.write(y_unit_ascii);
            slave_select.write(1); //nego lo slave select attivo basso
            
            //componente z dell'accelarazione
            //scrivo codice ascii delle decine nel display nel display dedicato 
            //command_location = ( command_wr | loc_z_tens ); //1000 100 = 0x84
            command_location = 0x84;
            slave_select.write(0); //asserisco lo slave select attivo basso
            spi.write(command_location);
            spi.write(z_tens_ascii);
            slave_select.write(1); //nego lo slave select attivo basso
            //scrivo codice ascii delle unità nel display nel display dedicato 
            //command_location = ( command_wr | loc_z_unit ); //1000 101 = 0x85
            command_location = 0x85;
            slave_select.write(0);
            spi.write(command_location);
            spi.write(z_unit_ascii);
            slave_select.write(1);
        
    }
}
