#include "mbed.h"
#include "MMA8451Q.h"
#include "I2C.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
PinName const SDA = PTB1;
PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)


//instanzia e inizializza oggettto i2c della clase I2C
I2C i2c(SDA,SCL); // SDA I2C data line pin  
                //  SCL I2C clock line pin  


char address_wr = 0x3A ; //byte per eseguire lettura: address_device + bit_wr(W=0)
char address_rd = 0x3B ; //byte per eseguire scrittura: address_device + bit_rd(R=1)
char CTRL_REG_1 = 0x2A ; // register address del CTRL_REG_1
char CTRL_REG_2 = 0x2B ; // register address del CTRL_REG_2
char CTRL_REG_3 = 0x2C ; // register address del CTRL_REG_3
char CTRL_REG_4 = 0x2D ; // register address del CTRL_REG_4
char CTRL_REG_5 = 0x2E ; // register address del CTRL_REG_5
char data = 0xFA ; // inizalizza la variabile data con le impostazioni da scrivere su CTRL_REG_1
char OUT_X_MSB = 0x01 ; // parte più significativa del registro contenete l'accelerazione sull'asse x 
char OUT_Y_MSB = 0x03 ; // parte più significativa del registro contenete l'accelerazione sull'asse y
char OUT_Z_MSB = 0x05 ; // parte più significativa del registro contenete l'accelerazione sull'asse z
char XYZ_DATA_CFG = 0x0E;// register address del XYZ_DATA_CFG
//ASLP_RATE0 = ASLP_RATE1 = 1 \\ per settare modalità campionamento in sleep a f=1.56Hz
//DR2=DR1=DR0 =1 \\ per settare campionamento in wake a f=1.56Hz
//LNOISE=0 //non attiva ridzuione del rumore (tanto la frequenza di campionamento è bassa)
//FREAD=1 // attiva modalità fast read, per campionare con 8bit ed avere risoluzione di 8 bit
//ACTIVE=0 // setta l'avccelerometro in standby per settare anche altri  registri

char FF_MT_CFG = 0x15; //registera addres del FF_MT_CFG (Frefall/Motionn Configuration register (Read/Write)
char INT_SOURCE = 0x0C;// register adderess del INT_SOURCE ( System Interrupt Status Register)
// if SRC_FF_MT=1 indicates that the frefall/motion function interrupt is active.
// This bit is asserted whenever "EA" bit i the FF_MT_SRC register is asserted adn the FF_MT interrupt has 
// been enabled
char FF_MT_SRC = 0x16; // register address del FF_MT_SRC (Frefall/Motion Source Register


int main(void)
{
    printf("inizio \n");
    //impostazione dei registri con scrittura Single Byte Write
    
    // setta impostazioni su CTRL_REG_1
    i2c.start(); // dai lo start
    i2c.write(address_wr); // scrivi e passa l'indirizzo del dispositivo con bit di scrittura
    i2c.write(CTRL_REG_1); // scrivi l'indirizzo del CTRL_REG_1
    i2c.write(data); // scrivi il "data" già inizializzato con le impostazioni del CTRL_REG_1
    i2c.stop();
    
    // setta impostazioni su CTRL_REG_2
    data=0x04; //imposta data con le impostazioni del CTRL_REG_2
    //ST=0 disabilita il self-test
    //RST=0 disabilita modalità reset
    //bit 5 don't care
    //SMODS0=SMODS1=0 setta la modalità oversampling_mode = normal , quando è in modalità in sleep    
    //SLPE=1 abilita l'autosleep
    //MODS0=MODS1=0 setta la modalità oversampling_mode = normal , quando è in modalità in active   
    i2c.start(); // dai lo start
    i2c.write(address_wr); // scrivi e passa l'indirizzo del dispositivo con bit di scrittura
    i2c.write(CTRL_REG_2); // scrivi l'indirizzo del CTRL_REG_2
    i2c.write(data); // scrivi il "data" contenete le impostazioni del CTRL_REG_2
    i2c.stop();    

    // setta impostazioni su CTRL_REG_3
    data=0x08; //imposta data con le impostazioni del CTRL_REG_3 attineti alle gestioni dell'interupt in modalità sleep
    // vedi data-sheet
    //Bit 7-> FIFO GATE   = 0 
    //Bit 6-> WAKE_TRANS  = 0
    //Bit 5-> WAKE_LNDRPT = 0
    //Bit 4-> WAKE_PULSE  = 0         
    //Bit 3-> WAKE_FF_MT  = 1 Frefall/Motion function interrupt can wake up !
    //Bit 2-> don't care
    //Bit 1-> IPOL  = 0
    //Bit 0-> PP_OD = 0
    i2c.start(); // dai lo start
    i2c.write(address_wr); // scrivi e passa l'indirizzo del dispositivo con bit di scrittura
    i2c.write(CTRL_REG_3); // scrivi l'indirizzo del CTRL_REG_3
    i2c.write(data); // scrivi il "data" contenete le impostazioni del CTRL_REG_3
    i2c.stop();    

    // setta impostazioni su CTRL_REG_4
    data=0x04; //imposta data con le impostazioni del CTRL_REG_4 attineti alle gestioni dell'interupt
    // vedi data-sheet
    // vedi data-sheet
    //Bit 7-> IN_EN_ASLP    = 0 ; se = 1 Auto-SLEEP/WAKE interrupt enabled
    //Bit 6-> INT_EN_FIFO   = 0
    //Bit 5-> INT_EN_TRANS  = 0
    //Bit 4-> INT_EN_LNDPRT = 0         
    //Bit 3-> INT_EN_PULSE  = 0  
    //Bit 2-> INT_EN_FF_MT  = 1 Freefall/Motion interrupt enabled
    //Bit 1-> don't care    = 0
    //Bit 0-> INT_EN_DRDY   = 0
    i2c.start(); // dai lo start
    i2c.write(address_wr); // scrivi e passa l'indirizzo del dispositivo con bit di scrittura
    i2c.write(CTRL_REG_4); // scrivi l'indirizzo del CTRL_REG_4
    i2c.write(data); // scrivi il "data" contenete le impostazioni del CTRL_REG_4
    i2c.stop();    

  // setta impostazioni su CTRL_REG_5 (NON UTILIZZATO!)
    data=0x00; //imposta data con le impostazioni del CTRL_REG_5 attineti alle gestioni dell'interupt nei pin
    // vedi data-sheet
    i2c.start(); // dai lo start
    i2c.write(address_wr); // scrivi e passa l'indirizzo del dispositivo con bit di scrittura
    i2c.write(CTRL_REG_5); // scrivi l'indirizzo del CTRL_REG_5
    i2c.write(data); // scrivi il "data" contenete le impostazioni del CTRL_REG_5
    i2c.stop();   
        
    // setta impostazioni su XYZ_DATA_CFG
    data=0x00; //imposta data con le impostazioni del XYZ_DATA_CFG attineti alla dinamica che si vuole acquisire (+-2g)
    // FS1=FS0=0 imposta la dinamica +-2g 
    i2c.start(); // dai lo start
    i2c.write(address_wr); // scrivi e passa l'indirizzo del dispositivo con bit di scrittura
    i2c.write(XYZ_DATA_CFG); // scrivi l'indirizzo del XYZ_DATA_CFG
    i2c.write(data); // scrivi il "data" contenete le impostazioni del XYZ_DATA_CFG
    i2c.stop();  

    // setta impostazioni su FF_MT_CFG (Frefall/Motion Configuration Register (Read/Write)
    data=0xF8; //imposta data con le impostazioni del FF_MT_SRC attineti quando vogliamo svegliare il dispositivo dal wake
    //Bit 7-> ELE  = 1 ;event flag latch enabled in FF_MT_SRC 
    //Bit 6-> OAE  = 1 ;Motion Flag (OR combination)
    //Bit 5-> ZEFE = 1 ;se = 0 asse Z event dection disabled ; se = 1 asse X raise event flag on measured acceleration value beyond present threshold
    //Bit 4-> YEFE = 1 ;se = 0 asse Y event dection disabled ; se = 1 asse Y raise event flag on measured acceleration value beyond present threshold         
    //Bit 3-> XEFE = 1 ;se = 0 asse X event dection disabled ; se = 1 asse X raise event flag on measured acceleration value beyond present threshold
    //Bit 2-> = 0  don't care
    //Bit 1-> = 0  don't care
    //Bit 0-> = 0  don't care
    i2c.start(); // dai lo start
    i2c.write(address_wr); // scrivi e passa l'indirizzo del dispositivo con bit di scrittura
    i2c.write(FF_MT_CFG); // scrivi l'indirizzo del FF_MT_CFG
    i2c.write(data); // scrivi il "data" contenete le impostazioni del FF_MT_CFG
    i2c.stop();  

  
    //attiva il dispositivo (esce da standby)
    // setta impostazioni su CTRL_REG_1
    data=0xFB ; // mette a 1 il bit ACTIVE e lascia invariati gli altri (già impostati)
    i2c.start(); // dai lo start
    i2c.write(address_wr); // scrivi e passa l'indirizzo del dispositivo con bit di scrittura
    i2c.write(CTRL_REG_1); // scrivi l'indirizzo del CTRL_REG_1
    i2c.write(data); // scrivi il "data" in le impostazioni del CTRL_REG_1
    i2c.stop();

    //lettura degli assi con lettura Multiple Byte Read   
    //float x_axis, y_axis, z_axis;
    //i2c.start();
    //i2c.write(address_wr); // scrivi e passa l'indirizzo del dispositivo con bit di scrittura
    //i2c.write(OUT_X_MSB);  // scrivi l'indirizzo del registro contente l'accelerazione sull'asse X
    //i2c.start();
    //i2c.write(address_rd); // scrivi e passa l'indirizzo del dispositivo con bit di read
    //x_axis=i2c.write(1); // scrive bit di AK (acknowlodgement) e salva il dato sul bus su x_axis
    //y_axis=i2c.write(1); // scrive bit di AK (acknowlodgement) e salva il dato sul bus su y_axis
    //z_axis=i2c.write(0); // scrive bit di AK (acknowlodgement) e salva il dato sul bus su z_axis
    //i2c.stop();
        
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);    
    
        
    printf("MMA8451 ID: %d\n", acc.getWhoAmI());


    char stato_FF_MT_SRC  = 0x00 ;
    char stato_INT_SOURCE = 0x00 ;
    float x_axis, y_axis, z_axis;
    while (true) {
    printf("sono dentro il while \n");
    //lettura del registro di stato FF_MT_SRC (read only)
    //Bit 7-> EA   = 1 one or more event flag has been asserted 
    //Bit 6-> don't care
    //Bit 5-> ZHE  
    //Bit 4-> ZHP  
    //Bit 3-> YHE           
    //Bit 2-> YHP  
    //Bit 1-> XHE 
    //Bit 0-> XHP 
    
    //lettura del registro di stato INT_SOURCE (read only)
    //Bit 7-> SRC_ASLP   = 1 one or more event flag has been asserted 
    //Bit 6-> SRC_FIFO
    //Bit 5-> SRC_TRANS  
    //Bit 4-> SRC_LNDPRT
    //Bit 3-> SRC_PULSE    
    //Bit 2-> SRC_FF_MT 
    //Bit 1-> DONT'CARE
    //Bit 0-> SRC_DRDY 
    
    //lettura single byte read
        i2c.start();
        i2c.write(address_wr); // scrivi e passa l'indirizzo del dispositivo con bit di scrittura
        i2c.write(INT_SOURCE);  // scrivi l'indirizzo del registro
        i2c.start();
        i2c.write(address_rd); // scrivi e passa l'indirizzo del dispositivo con bit di read
        stato_INT_SOURCE=i2c.read(0);
        i2c.stop();
        printf("stato_INT_SOURCE: %1.2d \n", stato_INT_SOURCE);
    //lettura single byte read
        i2c.start();
        i2c.write(address_wr); // scrivi e passa l'indirizzo del dispositivo con bit di scrittura
        i2c.write(FF_MT_SRC);  // scrivi l'indirizzo del registro
        i2c.start();
        i2c.write(address_rd); // scrivi e passa l'indirizzo del dispositivo con bit di read
        stato_FF_MT_SRC=i2c.read(0);
        i2c.stop();
        printf("stato_FF_MT_SRC: %1.2d \n", stato_FF_MT_SRC);
        //controllo sullo stato
        // se il flag  SRC_FF_MT==1 (bit 7) del registro INT_SOURCE
        if (stato_INT_SOURCE &&0x04 == 0x04) {
        printf("Buongiorno \n");
       //lettura degli assi con lettura Multiple Byte Read   
       // i2c.start();
       // i2c.write(address_wr); // scrivi e passa l'indirizzo del dispositivo con bit di scrittura
       // i2c.write(OUT_X_MSB);  // scrivi l'indirizzo del registro contente l'accelerazione sull'asse X
       // i2c.start();
       // i2c.write(address_rd); // scrivi e passa l'indirizzo del dispositivo con bit di read
       // x_axis=i2c.read(1); // scrive bit di AK (acknowlodgement) e salva il dato sul bus su x_axis
       // y_axis=i2c.read(1); // scrive bit di AK (acknowlodgement) e salva il dato sul bus su y_axis
       // z_axis=i2c.read(0); // scrive bit di AK (acknowlodgement) e salva il dato sul bus su z_axis
       // i2c.stop();  
       
       //lettura degli assi con lettura Single Byte Read   
       // asse x 
        i2c.start();
        i2c.write(address_wr); // scrivi e passa l'indirizzo del dispositivo con bit di scrittura
        i2c.write(OUT_X_MSB);  // scrivi l'indirizzo del registro contente l'accelerazione sull'asse X
        i2c.start();
        i2c.write(address_rd); // scrivi e passa l'indirizzo del dispositivo con bit di read
        x_axis=i2c.read(0); // scrive bit di NAK (no acknowlodgement) e salva il dato sul bus su x_axis
        i2c.stop();
        // asse y
        i2c.start();
        i2c.write(address_wr); // scrivi e passa l'indirizzo del dispositivo con bit di scrittura
        i2c.write(OUT_Y_MSB);  // scrivi l'indirizzo del registro contente l'accelerazione sull'asse Y
        i2c.start();
        i2c.write(address_rd); // scrivi e passa l'indirizzo del dispositivo con bit di read
        y_axis=i2c.read(0); // scrive bit di NAK (no acknowlodgement) e salva il dato sul bus su y_axis
        i2c.stop();
        // asse Z
        i2c.start();
        i2c.write(address_wr); // scrivi e passa l'indirizzo del dispositivo con bit di scrittura
        i2c.write(OUT_Z_MSB);  // scrivi l'indirizzo del registro contente l'accelerazione sull'asse Z
        i2c.start();
        i2c.write(address_rd); // scrivi e passa l'indirizzo del dispositivo con bit di read
        z_axis=i2c.read(0); // scrive bit di NAK (no acknowlodgement) e salva il dato sul bus su z_axis
        i2c.stop();  
       
        //accendo led
        rled = 1.0f - x_axis/256;
        gled = 1.0f - y_axis/256;
        bled = 1.0f - z_axis/256;
        wait(0.1f);
        //scrivo sulla seriale
        printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n", x_axis/256, y_axis/256, z_axis/256);
        }
    else {
        printf("sto ancora dormendo\n");
         }
    }
}

