#include "mbed.h" //the library that is connected - h stands for HeaderFile
#include "LCD_DISCO_F746NG.h" //Lib for the screen

DigitalOut myled(D4); //the light that this program connect to.
DigitalIn button(D3); //where the button are
LCD_DISCO_F746NG lcd; //Define lcd as the LCD screen
AnalogIn temper(A0); //Defines the temp sensor

void Temp() {
    float temp;
        
        temp = temper.read()*34.37; //Reads the input
        char result[24];
        snprintf(result, sizeof(result)
        ,"Current temp are: %f",temp);
               
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt( 0, LINE(5),(uint8_t*)result, CENTER_MODE);
    wait(.2);
  
};

void ButtonText() {
    while (1) {
        if (button) {
            myled = 1;
        lcd.SetBackColor(LCD_COLOR_BLACK);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.Clear(LCD_COLOR_BLACK);
        lcd.DisplayStringAt( 0, LINE(5),(uint8_t*)"Wow... Perfect.", CENTER_MODE);
        lcd.DisplayStringAt( 0, LINE(6),(uint8_t*)"You pressed my button!", CENTER_MODE);
        wait(.5);
        } else {
            myled = 0;
            lcd.Clear(LCD_COLOR_BLACK);
            Temp();
        }
    }
};


int main() {  //function - integer (numbers)
    ButtonText();
};
