#include "mbed.h"
#include "LCD_DISCO_F746NG.h"

DigitalOut ledRE(D2);
DigitalOut ledGR(D7);
DigitalOut ledBL(D6);
DigitalOut ledIND(LED4); 
DigitalIn button(D3);
LCD_DISCO_F746NG lcd;
AnalogIn tempCalc(A0);

int main() {
    button.mode(PullUp);
    int prevValue = 0;  
    //printf("Data transfer complete.\n");

    while(1) {
        float temp = tempCalc.read()*27.21;
        printf("%f\n", temp);
        char result[18];
        snprintf(result, sizeof(result), "Current temp %f", temp);
        wait(0.1);
        if (button == 1 && prevValue == 0){
            if (ledRE == 1 && ledGR == 1 && ledBL && ledIND){
                
                lcd.Clear(LCD_COLOR_BLACK);
                
                ledIND = 0;
                wait(0.2);
                ledBL = 0;
                wait(0.2);
                ledGR = 0;               
                wait(0.2);
                ledRE = 0;
            }
            else {
                
                lcd.SetBackColor(LCD_COLOR_BLACK);
                lcd.SetTextColor(LCD_COLOR_WHITE);
                wait(0.2);
                lcd.DisplayStringAt(0, LINE(5), (uint8_t *)result, CENTER_MODE);
                
                
                
                ledIND = 1;
                wait(0.2);
                ledBL = 1;
                wait(0.2);
                ledGR = 1;               
                wait(0.2);
                ledRE = 1;
            }
            prevValue = 1;
        }
        else if (button == 0){
            prevValue = 0;
        }

    }
}