#include "mbed.h"
#include "SDFileSystem.h"
#include "MPU6050.h"
 
SDFileSystem sd(dp2, dp1, dp6, dp4,"sd"); 

DigitalOut myled(LED1);
Serial pc(USBTX,USBRX);
MPU6050 mpu;
Timer t;

int16_t ax, ay, az;
int16_t gx, gy, gz;

char c;

int main() {
    
    
    pc.printf("MPU6050 test\n\n");
    pc.printf("MPU6050 initialize \n");

    mpu.initialize();
    pc.printf("MPU6050 testConnection \n");

    bool mpu6050TestResult = mpu.testConnection();
    if(mpu6050TestResult) {
        pc.printf("MPU6050 test passed \n");
    } else {
        pc.printf("MPU6050 test failed \n");
    }
    t.start();
    
    pc.printf("Hello World!\n"); 
    mkdir("/sd/ANBU!", 0777);
    
    while(1){  
        FILE *fp = fopen("/sd/ANBU!/AUO.txt", "a");
        if(fp == NULL) {
            error("Could not open file for write\n"); 
            }

        wait(0.1);
        mpu.getMotion6(&ax, &ay, &az, &gx, &gy, &gz);
        //writing current accelerometer and gyro position 
        pc.printf("%f, %d, %d, %d, %d,%d, %d\n\r",t.read(),ax,ay,az,gx,gy,gz);
        fprintf(fp,"%f, %d, %d, %d, %d,%d, %d\n\r",t.read(),ax,ay,az,gx,gy,gz);       

  
    fprintf(fp,"\n\r");   
    pc.printf("\n\r");
    fclose(fp);
    free(fp);
    
    }
}
