#include "mbed.h"
#include "SakuraIO.h"

#define SEND_INTERVAL 5 // 送信間隔 秒単位

PwmOut iine_led(PB_4);
DigitalIn iine_button(PB_3);
DigitalOut status_led(PB_5);

I2C i2c(PB_7, PB_6); // sda, scl
SakuraIO_I2C sakuraio(i2c);

uint64_t counter = 0;   // 死亡検知用カウンタ
uint32_t iine_count = 0; // 押された回数

Ticker tick;

void timer()
{
    // 1秒間隔で呼び出される
    static int sec_count = 1;
    __disable_irq();

    if (sec_count >= SEND_INTERVAL)
    {
        // SEND_INTERVAL秒に1回iine_countを集計して方針
        sec_count = 0;
        sakuraio.clearTx();
        sakuraio.enqueueTx(0, counter);
        sakuraio.enqueueTx(1, iine_count);
        sakuraio.send();
        counter++;
        iine_count = 0;
    }
    sec_count++;
    __enable_irq();
}

int main()
{
    int led_counter = 0;
    iine_button.mode(PullUp);

    // 通信モジュールリンクアップ待ち
    for (;;)
    {
        iine_led = 1;

        for (float p = 0.0f; p < 1.0f; p += 0.01f)
        {
            iine_led = p;
            wait(0.01);
        }
        for (float p = 1.0f; p > 0.0f; p -= 0.01f)
        {
            iine_led = p;
            wait(0.01);
        }
        iine_led = 0;
        if ((sakuraio.getConnectionStatus() & 0x80) == 0x80)
            break;
        wait(1);
    }

    // リンクアップしたよアピール
    iine_led = 1;
    wait(1);
    iine_led = 0;
    wait(1);
    iine_led = 1;

    // 1秒間隔のタイマー作成
    tick.attach(&timer, 1);

    for (;;)
    {
        if (iine_button == 0)
        {
            // ボタンが押されたらカウントアップしてから派手に点滅
            wait(0.5);
            while (iine_button == 0) // ボタンを放すまでブロック
                ;
            iine_count++; // いいね回数カウントアップ

            // 以下派手に点滅
            iine_led = 1;
            for (int i = 0; i < 6; i++)
            {
                iine_led = !iine_led;
                wait(0.1);
            }
            iine_led = 1;
        }
        else
        {
            // ボタンが押されていなければ適当に点滅させておく
            if (led_counter < 100)
                iine_led = 0;
            else
                iine_led = 1;

            if (led_counter > 1100)
                led_counter = 0;
            else
                led_counter++;
            wait(0.1);
        }
    }
}
