
#ifndef GPS_DECODER_H
#define GPS_DECODER_H

#include "mbed.h"
#include <string.h>
#include <stdint.h>
#include <stdlib.h>
#include <math.h>


#define NMEA_BUF_LEN 128
#define MAXTOKEN 32

class GPSDecoder
{
public:
    GPSDecoder() { }
    GPSDecoder(char *nmea_msg) {
        set_nmea_message(nmea_msg);
    }

    void set_nmea_message(char *nmea_msg);
    void decode();
    uint8_t validate();
    void dump_info(char *buf);

    double get_latitude() {
        return latitude;
    }
    double get_longitude() {
        return longitude;
    }
    float get_speed() {
        return speed;
    }
    float get_move_direction() {
        return move_direction;
    }
    uint16_t get_year() {
        return year;
    }
    uint8_t get_month() {
        return month;
    }
    uint8_t get_day() {
        return day;
    }
    uint8_t get_hour() {
        return hour;
    }
    uint8_t get_min() {
        return min;
    }
    uint8_t get_sec() {
        return sec;
    }
    uint8_t get_msec() {
        return msec;
    }
    time_t get_unixtime();

private:
    long str2int(char *src_ptr, uint8_t len);
    int split(char *str, const char delim, char *token[], int max_item);

    char nmea_line[NMEA_BUF_LEN];

    double latitude;
    double longitude;
    float speed;
    float move_direction;
    uint16_t year;
    uint8_t month;
    uint8_t day;
    uint8_t hour;
    uint8_t min;
    uint8_t sec;
    uint16_t msec;
};


#endif