#include "mbed.h"
#include "SakuraIO.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
LocalFileSystem local("local");

void rx_interrupt();
void err2str(int err);

int main()
{
    FILE *fp ;
    pc.baud(115200);
    fp = fopen("/local/file.bin", "wb");
    if (fp == NULL) {
        pc.printf("error: fp is null\r\n");
    }

    I2C i2c(p9, p10);
    SakuraIO_I2C sakuraio(i2c);

    pc.printf("waiting to come online");
    for (;;) {
        if ((sakuraio.getConnectionStatus() & 0x80) == 0x80)
            break;
        pc.printf(".");
        wait_ms(1000);
    }
    pc.printf("ok\r\n");

    uint8_t status = 0;
    while (status != 1) {
        status = sakuraio.startFileDownload(1);
        pc.printf("file req result: %d\r\n", status);
        if (status != CMD_ERROR_NONE) {
            err2str(status);
            pc.printf("\r\n");
        }
        wait_ms(100);
        pc.printf("cancel\r\n");
        uint8_t cancel_result = sakuraio.cancelFileDownload();
        err2str(cancel_result);
        pc.printf("\r\n");
        wait_ms(100);
    }



    uint32_t received_size = 0;

    uint8_t file_status = 0;
    uint32_t file_total_size = 0, file_crc32 = 0;
    uint64_t file_timestamp = 0;
    while(file_status == 0) {

        sakuraio.getFileMetaData(&file_status, &file_total_size, &file_timestamp, &file_crc32);

        pc.printf("metadata status: %d filesize: %d crc32: %08x\r\n", file_status, file_total_size, file_crc32);

        pc.printf("date ");
        for (int i = 0; i < 8; i++) {
            pc.printf("%02x ", ((uint8_t *)&file_timestamp)[i]);
        }
        pc.printf("\r\n");
        wait(1);
    }

    while (1) {
        status = 0;
        uint32_t s = 0;
        uint8_t a = sakuraio.getFileDownloadStatus(&status, &s);
        pc.printf("result: ");
        err2str(a);
        pc.printf("status %d size %d\r\n", status, s);
        wait_ms(500);

        uint8_t buf[255] = {0};
        uint8_t len = 251; // request size
        uint8_t fileget = sakuraio.getFileData(&len, buf);
//        if (fileget != cmd_error_none) {
//            pc.printf("download waiting...\r\n");
//            wait_ms(1000);
//            continue;
//            //break;
//        }

        pc.printf("file get ");
        err2str(fileget);
        if (fileget != 1) {
            pc.printf("error: get_data returned invalid status\r\n");
            while(1) {
                wait(1);
            }
        }
        pc.printf("len %d\r\n", len);
        received_size += len;
        pc.printf("received %08x\r\n", len);
        for (int i = 0; i < len; i++) {
            pc.printf("%02x ", buf[i]);
        }
        fwrite(buf, len, 1, fp);
        pc.printf("\r\n");
        pc.printf("%d / %d (%f%%)\r\n", received_size, file_total_size, ((double)received_size / file_total_size) * 100);
        if (received_size >= file_total_size) {
            break;
        }
        wait_ms(100);
    }
    fclose(fp);
    pc.printf("download complete!\r\n");

    // block
    while (1)
        ;
}

void err2str(int err)
{
    switch (err) {
        case CMD_ERROR_NONE:
            printf("no error.");
            break;
        case CMD_ERROR_PARITY:
            printf("parity error.");
            break;
        case CMD_ERROR_MISSING:
            printf("command missing.");
            break;
        case CMD_ERROR_INVALID_SYNTAX:
            printf("invalid syntax.");
            break;
        case CMD_ERROR_RUNTIME:
            printf("runtime error.");
            break;
        case CMD_ERROR_LOCKED:
            printf("command locked.");
            break;
        case CMD_ERROR_BUSY:
            printf("busy.");
            break;
    }
}