#include <string.h>
#include <mbed.h>
#include <AQM0802A.h>
#include <SakuraIO.h>
#include "SakuraPinNames.h"

// Serial over CMSIS_DAP
Serial pc(DAP_UART_TX, DAP_UART_RX, 9600);

// sakura.io
DigitalOut wake_in(SCM_WAKE_IN);
DigitalIn  wake_out(SCM_WAKE_OUT);

// LED
DigitalOut led_1(LED1);
DigitalOut led_2(LED2);
DigitalOut led_3(LED3);
DigitalOut led_4(LED4);

DigitalOut leds[] = {led_1, led_2};

// LCD backlight
DigitalOut lcd_led(LED_LCD);

// Switch
DigitalIn sw_1(SW1);
DigitalIn sw_2(SW2);
DigitalIn sw_3(SW3);
DigitalIn sw_4(SW4);
DigitalIn sw_5(SW5);
DigitalIn sw_6(SW6);

DigitalIn sws[] = {sw_1, sw_2};

// Internal I2C
I2C internal_i2c(I2C_INTERNAL_SDA, I2C_INTERNAL_SCL);
AQM0802A lcd(internal_i2c);

// sakura.io
//SakuraIO_I2C sakuraio(I2C_SDA, I2C_SCL);
SPI sakuraio_spi(PB_15, PB_14, PB_13);
DigitalOut sakuraio_cs(PB_12);
SakuraIO_SPI sakuraio(sakuraio_spi, sakuraio_cs);

static void setup()
{
    char uid[32];
    
    wake_in = 1;

    pc.printf("Hello World !\r\n");
    lcd.cls();
    lcd.printf("Hello");
    
    while (sw_6 == 0) {
        wait(0.1);
    } 

    lcd_led = 1;

    memset(uid, 0, sizeof(uid));
    sakuraio.getUniqueID(uid);
    lcd.cls();
    pc.printf("UniqueID: %s\r\n", uid);
    
    lcd.printf("........");
    led_4 = 1;
}

static void loop()
{
    uint8_t mode = 0xff;
    static uint8_t prev_sw[3] = {1, 1};
    uint8_t send_sw;
    static uint8_t prev_send_sw = 1;
    uint8_t cnstat;
    static uint8_t prev_cnstat = 0xff;

    // WAKE_INを設定
    if (wake_in != sw_5) {
        lcd.cls(); 
        if (sw_5 == 1) {
            lcd.printf("Running");
        } else {
            lcd.printf("DeepSleep");
            cnstat = 0xff;
            led_4 = 0;
        }
    }
    wake_in = sw_5;
    if (wake_in == 0) {
        wait(0.1);
        return;
    }
    
    // 動作中LEDを点滅させる
    led_4 = !led_4;
    
    // 省電力モードをSW1-SW3で選択する。
    for (int i = 0; i < 3; i++) {
        if ((prev_sw[i] == 1) && (sws[i] == 0)) {
            mode = i;
        }
        prev_sw[i] = sws[i];
    }
    if (mode < 3) {
        pc.printf("Selected PowerSaveMode: %d\r\n", mode);
        uint8_t ret = sakuraio.setPowerSaveMode(mode);
        pc.printf("setPowerSaveMode(): %d\r\n", ret);
    }
    
    // 選択されている省電力モードを取得
    uint8_t stat = sakuraio.getPowerSaveMode();
    led_1 = (stat == 0) ? 1 : 0;
    led_2 = (stat == 1) ? 1 : 0;
    
    // 接続状態を表示
    cnstat = sakuraio.getConnectionStatus();
    if (prev_cnstat != cnstat) {
        lcd.cls();
        if ((cnstat & 0x80) == 0x80 ) {
            lcd.printf("Online");
        } else {
            lcd.printf("Offline");
        }
    }
    prev_cnstat = cnstat;
    
    // 選択されている省電力モードをsakura.ioで送信
    send_sw = sw_4;
    if ((cnstat & 0x80) == 0x80) {
        if ((prev_send_sw == 1) && (send_sw == 0)) {
            sakuraio.enqueueTx(0, (int32_t)stat);
            sakuraio.send();
        }
    }
    prev_send_sw = send_sw;
    
    uint8_t available, queued;
    if (sakuraio.getRxQueueLength(&available, &queued) == CMD_ERROR_NONE) {
        for (int i = 0; i < queued; i++) {
            uint8_t ch, typ, val[8];
            int64_t offset;
            if (sakuraio.dequeueRx(&ch, &typ, val, &offset) == CMD_ERROR_NONE) {
                if (ch == 0) {
                    lcd_led = val[0];
                }
            }
        }
    }
    wait(0.2);
}

int main()
{
    setup();
    while(1) {
        loop();
    }
}
