/* SAKURA Internet IoT Communication Module Library for mbed
 *
 * The MIT License (MIT)
 *
 * Copyright (c) SAKURA Internet Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the Software
 * is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "mbed.h"
#include "SakuraIO.h"
#include "SakuraIO/debug.h"


void SakuraIO_SPI::begin(){
  dbgln("CS=0");
  cs = 0;
}

void SakuraIO_SPI::end(){
  dbgln("CS=1");
  cs = 1;
  wait_us(20);
}

void SakuraIO_SPI::sendByte(uint8_t data){
  wait_us(20);
  dbg("Send=");
  dbgln(data);
  wait_us(10);
  spi.write(data);
}


uint8_t SakuraIO_SPI::receiveByte(bool stop){
  return receiveByte();
}

uint8_t SakuraIO_SPI::receiveByte(){
  uint8_t ret;
  wait_us(10);
  ret = spi.write(0x00);
  dbg("Recv=");
  dbgln(ret);
  return ret;
}

SakuraIO_SPI::SakuraIO_SPI(SPI &_spi, DigitalOut &_cs): spi(_spi), cs(_cs){
    cs = 1;
}
