/* SAKURA Internet IoT Communication Module Library for mbed
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) SAKURA Internet Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the Software
 * is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __SAKURA_IO_DEBUG_H__
#define __SAKURA_IO_DEBUG_H__


#if defined(SAKURA_DEBUG)
#define dbg(...) printf(__VA_ARGS__)
#define dbgln(...) DEBUG_PRINTF_LN(__VA_ARGS__, "\r\n")
#define DEBUG_PRINTF_LN(type, fmt, ...) printf(fmt "%s", __VA_ARGS__)
#else
#define dbg(...)
#define dbgln(...)
#endif

#endif //__SAKURA_IO_DEBUG_H__
