#ifndef NEO_M8M_H_
#define NEO_M8M_H_

#include "mbed.h"

/*
 * Custom NEO-M8M library used into interact with the
 * UBlox NEO-M8M GPS module on the LRAT and Disco Prototype Board
 */

class NeoM8M
{   
    public:
    
        /**
         */
        NeoM8M();
        
        /**
         */
        NeoM8M(I2C *_i2c);
        
        /**
         */
        virtual ~NeoM8M();
        
        /**
         */
        void setI2C(I2C *_i2c);
        
        /**
         */
        void init(char *_buf, uint8_t *_pos, uint32_t *_mytime, double *_mylat, double *_mylon);
        
        /**
         */
        int read();
        
        /**
         */
        void sleep();
        
        /**
         */
        void wake();

        /**
         */
        void ubxRead();
        
        /**
         */
        char *buf;
        double *mylat;
        double *mylon;
        uint8_t *pos;
        uint32_t *mytime;
        
        /**
         */
        static char sleepCommand[12];
        static char wakeCommand[12];
        static char resetDefaults[21];
        
    private:
        
        /**
         */
        void executeCommand(char *command, int length);
        
        /**
         */
        I2C *i2c;
};

#endif