#include "mbed.h"
#define T 0.0001                                                                //Periode PWM 1 ms
#define distance_select 0.6;

Serial pc(USBTX, USBRX);
DigitalIn jack(D3);
DigitalIn FDC(D2);
PwmOut MoteurDroit(D6);
PwmOut MoteurGauche(D8);
Timer timer;

int main()
{
    int valjack,valFDC,status=0,rcycl_d=79, rcycl_g=80,cote=0;
    float vitesse = 0.4, distance_min = 0.6, distance_max = 2;
    float distance_select = 1                                                   // 1 metre
    float temps = (distance_select/vitesse)*1000;                               // *1000ms
    MoteurDroit.period(T);
    MoteurGauche.period(T);

    while (1) {
        valjack=jack.read();                                                    //Lecture des capteurs
        valFDC=FDC.read();

        switch (status) {
            case 0:                                                             //Depart jack
                if (valjack==1)                   status=2;
                break;
            case 1:                                                             //Retour status initial jack : attente du jack IN
                if (valjack==0)                   status=0;
                break;
            case 2:                                                             //Si ligne capteur gauche, si ligne capteur droit
                if (valFDC==0)                    status=1;
                timer.start();
                if(cote==4)                       status=1;
                if (timer.read_ms() > temps) {
                    timer.reset();
                    cote++;
                    status=3;
                }
                break;
            case 3:
                if (valFDC==0)                    status=1;
                timer.start();
                if (timer.read_ms() > temps) {
                    timer.reset();
                    status=2;
                }
                break;
        }

        switch (status) {
            case 0:                                                             //Arrêt moteurs, jack IN
                MoteurDroit.write(1);
                MoteurGauche.write(1);
                printf("0\n\r");
                break;
            case 1:                                                             //Arrêt moteurs, FDC actif 1 fois
                MoteurDroit.write(1);
                MoteurGauche.write(1);
                printf("1\n\r");
                break;
            case 2:
                MoteurDroit.pulsewidth_us(rcycl_d);
                MoteurGauche.pulsewidth_us(rcycl_g);
                break;
            case 3:
                MoteurDroit.write(1);
                MoteurGauche.pulsewidth_us(rcycl_g);
                break;
        }
    }
}