#include "mbed.h"
#include "time.h"
#define T 0.0001                                                                //Periode PWM 1 ms  
#define k 36;                                                                   //Coefficient erreur

Serial pc(USBTX, USBRX);
DigitalIn Jack(D3);
DigitalIn FDC(D2);
AnalogIn vmes(A0);
AnalogIn capt1(A1);
AnalogIn capt2(A2);
AnalogIn capt3(A3);
AnalogIn capt4(A4);
PwmOut MoteurDroit(D6);
PwmOut MoteurGauche(D8);

int main()
{
    int jack,fdc,suivi_ligne=0,
    float c1,c2,c3,c4;
    float vbat;
    float vg, vd, rcycl=30, e, vmoy;
    MoteurDroit.period(T);
    MoteurGauche.period(T);
     
    vg = vmoy + k * e;
    vg = vmoy + k * e; 

    while (1) {
        jack=Jack.read();                                                    //Lecture des capteurs
        fdc=FDC.read();
        c1=capt1.read();                                                   //cpt1 : gauche || cpt2 : droit
        c2=capt2.read();
        c3=capt3.read();                                                   //cpt1 : gauche || cpt2 : droit
        c4=capt4.read();
        vbat=vmes.read()*3.3*(59/12);
        e=c2-c3;
        vmoy=rcycl*12/vbat;
      
        switch (suivi_ligne) {
            case 0:                                                             //Depart Jack
                if (jack==1)                   suivi_ligne=1;
                break;
            case 1:
                if (fdc==0)                    suivi_ligne=10;
                if ((c2 < 0.5) && (c3 > 0.5))  suivi_ligne=20;
                if ((c2 > 0.5) && (c3 < 0.5))  suivi_ligne=30;                  //Detection de ligne à droite
                if ((c1 < 0.5) && (c2 < 0.5) &&(c3 < 0.5) && (c4 < 0.5))        //Intersection
                                               suivi_ligne=40;
                break;
            case 10:                                                            //Etat fdc actif attente retour état initial avec Jack IN
                if (jack==0)                   suivi_ligne=0;
                break;
            case 20:                                                            //Tourner à gauche
                if (fdc==0)                    suivi_ligne=10;
                if (c2 > 0.5)                  suivi_ligne=1;
                if ((c1 < 0.5) && (c2 < 0.5) &&(c3 < 0.5) && (c4 < 0.5))        //Intersection
                break;
            case 30:                                                            //Tourner à droite
                if (fdc==0)                    suivi_ligne=10;
                if (c3 > 0.5)                  suivi_ligne=1;
                if ((c1 < 0.5) && (c2 < 0.5) &&(c3 < 0.5) && (c4 < 0.5))        //Intersection
                break;
        }

        switch (suivi_ligne) {
            case 0:                                                             //Arrêt moteurs, Jack IN
                MoteurDroit.write(1);
                MoteurGauche.write(1);
                break;
            case 1:                                                             //Accélération ligne droite                                            
                vd = vmoy + e * k;
                vg = vmoy + e * k;
                if(vd > 100) vd = 100;
                if(vg > 100) vg = 100;
                MoteurDroit.pulsewidth_us(100-vd);                               
                MoteurGauche.pulsewidth_us(100-vg);
                break;
            case 10:                                                            //Arrêt moteurs avec fin de course, attente de JACK IN pour retour à l'état initial
                MoteurDroit.write(1);
                MoteurGauche.write(1);
                break;
            case 20:                                                            //Tourner à gauche
                vd = vmoy + e * k;
                vg = vmoy - e * k;
                if(vd > 100) vd = 100;
                if(vg < 0) vg = 0;
                MoteurDroit.pulsewidth_us(100-vd);
                MoteurGauche.pulsewidth_us(100-vg);
                break;
            case 30:                                                            //Tourner à droite
                vd = vmoy - e * k;
                vg = vmoy + e * k;
                if(vd < 0) vd = 0;
                if(vg > 100) vg = 100;
                MoteurDroit.pulsewidth_us(100-vd);
                MoteurGauche.pulsewidth_us(100-vg);
                break;
            case 40:                                                            //Accélération ligne droite 
                vd = vmoy + e * k;
                vg = vmoy + e * k;
                if(vd > 100) vd = 100;
                if(vg > 100) vg = 100;
                MoteurDroit.pulsewidth_us(100-vd);                               
                MoteurGauche.pulsewidth_us(100-vg);
                break;            
        }
    }
}