#include "mbed.h"
#define T 0.0001                                                                //Periode PWM 1 ms  
#define k 36;                                                                   //Coefficient erreur

DigitalIn bp1(D4);
DigitalIn bp2(D5);
DigitalIn bp3(D10);
DigitalOut led_rouge(D14);
DigitalOut led_jaune(D13);
DigitalOut led_vert(D15);


void suivi_ligne(void);
void confetti(void);
void carre(float);

int main()
{
    int bp_1, bp_2, bp_3,prog=0;
    int distance = 0.6;

    while (1) {
        bp_1=bp1.read();
        bp_2=bp2.read();
        bp_3=bp3.read();
        printf("etat= %d\n\r",prog);
        
        
        switch(prog) {
            case (0):                                                           //Voyants éteints
                if(bp_1==1) prog=1;                                             //BP MODE pour SELECTION
                break;
            case(1):                                                            //SELECTION LED VERTE
                if(bp_1==1) prog=2;                                             //BP MODE pour SELECTION
                if(bp_3==1) prog=11;                                            //BP VALIDATION MODE
                break;
            case (2):                                                           //ATTENDRE BP RELACHE
                if(bp_1==0) prog=3;
                break;
            case(3):
                if(bp_1==1) prog=4;
                if(bp_3==1) prog=21;
                break;
            case (4):
                if(bp_1==0) prog=5;
                break;
            case(5):
                if(bp_1==1) prog=6;
                if(bp_3==1) prog=31;
                break;
            case (6):
                if(bp_1==0) prog=1;
                break;
            case(11):
                if(bp_2==1) prog=0;
                break;
            case(21):
                if(bp_2==1) prog=0;
                break;
            case(31):
                if(bp_1==1) prog=32;
                if(bp_2==1) prog=34;
                if(bp_3==1) prog=36;
                break;
            case(32):
                if(bp_1==0) prog=33;
                break;
            case(33):
                prog=31;
                break;
            case(34):
                if(bp_2==0) prog=35;
                break;
            case(35):
                prog=31;
                break;
            case(36):
                if(bp_2==1) prog=0;
                break;
        }
        switch(prog) {
            case (0):
                led_rouge.write(0);
                led_jaune.write(0);
                led_vert.write(0);
                break;
            case (1):
                led_rouge.write(0);
                led_jaune.write(0);
                led_vert.write(1);
                break;
            case (2):
                led_rouge.write(0);
                led_jaune.write(0);
                led_vert.write(1);
                break;
            case (3):
                led_rouge.write(1);
                led_jaune.write(0);
                led_vert.write(0);
                break;
            case (4):
                led_rouge.write(1);
                led_jaune.write(0);
                led_vert.write(0);
                break;
            case (5):
                led_rouge.write(0);
                led_jaune.write(1);
                led_vert.write(0);
                break;
            case (6):
                led_rouge.write(0);
                led_jaune.write(1);
                led_vert.write(0);
                break;
            case (11):
                led_rouge.write(0);
                led_jaune.write(0);
                led_vert.write(1);
                //PROGRAMME LIGNE ICI
                suivi_ligne();
                break;
            case (21):
                led_rouge.write(1);
                led_jaune.write(0);
                led_vert.write(0);
                //PROGRAMME CONFETTIS ICI
                confetti();
                break;
            case (31):
                led_rouge.write(0);
                led_jaune.write(1);
                led_vert.write(0);
                break;
            case (32):
                led_rouge.write(0);
                led_jaune.write(1);
                led_vert.write(0);
                break;
            case (33):
                led_rouge.write(0);
                led_jaune.write(0);
                led_vert.write(0);
                //INCREMENTATION CARRE ICI
                distance = distance + 0.1;
                if (distance > 2.0){
                    distance = 2;
                    led_rouge.write(1);
                }
                break;
            case (34):
                led_rouge.write(0);
                led_jaune.write(1);                                             //Accueil mode carré LED JAUNE
                led_vert.write(0);
                break;
            case (35):
                led_rouge.write(0);
                led_jaune.write(0);
                led_vert.write(0);
                //DECREMENTATION CARRE ICI
                distance = distance - 0.1;
                if (distance < 0.6){
                    distance = 0.6;
                    led_vert.write(1);
                }
                break;
            case (36):
                led_rouge.write(0);
                led_jaune.write(1);
                led_vert.write(0);
                //PROGRAMME CARRE ICI
                carre(distance);
                break;
        }



    }
}

void suivi_ligne(void)
{
    DigitalIn Jack(D3);
    DigitalIn FDC(D2);
    AnalogIn vmes(A0);
    AnalogIn capt1(A1);
    AnalogIn capt2(A2);
    AnalogIn capt3(A3);
    AnalogIn capt4(A4);
    PwmOut MoteurDroit(D6);
    PwmOut MoteurGauche(D8);
    Timer timer;

    int jack,fdc,suivi_ligne=0;
    float c1,c2,c3,c4;
    float vbat;
    float vg, vd, rcycl=30, e, vmoy;
    MoteurDroit.period(T);
    MoteurGauche.period(T);

    while (1) {                                                                //
        jack=Jack.read();                                                    //Lecture des capteurs
        fdc=FDC.read();
        c1=capt1.read();                                                   //cpt1 : gauche || cpt2 : droit
        c2=capt2.read();
        c3=capt3.read();                                                   //cpt1 : gauche || cpt2 : droit
        c4=capt4.read();
        vbat=vmes.read()*3.3*(59/12);
        e=c2-c3;
        vmoy=rcycl*12/vbat;

        if ((c1 < 0.5) && (c4 > 0.5)) timer.start();
        if ((c1 < 0.5) && (c4 > 0.5) && (timer.read() > 0.5) && (timer.read() < 3)) suivi_ligne=50;
        if (timer.read()>3) {
            timer.stop();
            timer.reset();
        }

        switch (suivi_ligne) {
            case 0:                                                             //Depart Jack
                if (jack==1)                   suivi_ligne=1;
                break;
            case 1:
                if (fdc==0)                    suivi_ligne=10;
                if ((c2 < 0.5) && (c3 > 0.5))  suivi_ligne=20;
                if ((c2 > 0.5) && (c3 < 0.5))  suivi_ligne=30;                  //Detection de ligne à droite
                if ((c1 < 0.5) && (c2 < 0.5) &&(c3 < 0.5) && (c4 < 0.5))        //Intersection
                    suivi_ligne=40;
                break;
            case 10:                                                            //Etat fdc actif attente retour état initial avec Jack IN
                if (jack==0)                   suivi_ligne=0;
                break;
            case 20:                                                            //Tourner à gauche
                if (fdc==0)                    suivi_ligne=10;
                if (c2 > 0.5)                  suivi_ligne=1;
                if ((c1 < 0.5) && (c2 < 0.5) &&(c3 < 0.5) && (c4 < 0.5))        //Intersection
                    break;
            case 30:                                                            //Tourner à droite
                if (fdc==0)                    suivi_ligne=10;
                if (c3 > 0.5)                  suivi_ligne=1;
                if ((c1 < 0.5) && (c2 < 0.5) &&(c3 < 0.5) && (c4 < 0.5))        //Intersection
                    break;
            case 40:                                                            //Intersection
                if (fdc==0)                    suivi_ligne=10;
                if ((c1 > 0.5) && (c4 > 0.5))  suivi_ligne=1;
                break;
            case 50:
                if (c3 < 0.5)                   suivi_ligne=51;                 //Temporisation case 50,51,52 de C3 pour retrouver la ligne à gauche
                break;
            case 51:
                if (c3 > 0.5)                   suivi_ligne=52;
                break;
            case 52:
                if (c3 < 0.5)                   suivi_ligne=1;
                break;
        }

        switch (suivi_ligne) {
            case 0:                                                             //Arrêt moteurs, Jack IN
                MoteurDroit.write(1);
                MoteurGauche.write(1);
                break;
            case 1:                                                             //Accélération ligne droite
                vd = vmoy + e * k;
                vg = vmoy + e * k;
                if(vd > 100) vd = 100;
                if(vg > 100) vg = 100;
                MoteurDroit.pulsewidth_us(100-vd);
                MoteurGauche.pulsewidth_us(100-vg);
                break;
            case 10:                                                            //Arrêt moteurs avec fin de course, attente de JACK IN pour retour à l'état initial
                MoteurDroit.write(1);
                MoteurGauche.write(1);
                break;
            case 20:                                                            //Tourner à gauche
                vd = vmoy + e * k;
                vg = vmoy - e * k;
                if(vd > 100) vd = 100;
                if(vg < 0) vg = 0;
                MoteurDroit.pulsewidth_us(100-vd);
                MoteurGauche.pulsewidth_us(100-vg);
                break;
            case 30:                                                            //Tourner à droite
                vd = vmoy - e * k;
                vg = vmoy + e * k;
                if(vd < 0) vd = 0;
                if(vg > 100) vg = 100;
                MoteurDroit.pulsewidth_us(100-vd);
                MoteurGauche.pulsewidth_us(100-vg);
                break;
            case 40:                                                            //Accélération ligne droite
                vd = vmoy + e * k;
                vg = vmoy + e * k;
                if(vd > 100) vd = 100;
                if(vg > 100) vg = 100;
                MoteurDroit.pulsewidth_us(100-vd);
                MoteurGauche.pulsewidth_us(100-vg);
                break;
            case 50:
                timer.stop();
                timer.reset();
                MoteurDroit.pulsewidth_us(80);
                MoteurGauche.write(1);
                break;
            case 51:
                MoteurDroit.pulsewidth_us(80);
                MoteurGauche.write(1);
                break;
            case 52:
                MoteurDroit.pulsewidth_us(80);
                MoteurGauche.write(1);
                break;
        }
    }
}

void confetti(){                                                                

DigitalIn FDC(D2);
DigitalIn Jack(D3);
PwmOut MoteurDroit(D6);
PwmOut MoteurGauche(D8);
AnalogIn capt1(A1);                                                             //Ligne gauche
AnalogIn capt2(A2);                                                             //Croisement gauche
AnalogIn capt3(A3);                                                             //Ligne droite
AnalogIn capt4(A4);                                                             //Croisement droite


    int etat_confetti = 0, jack;
    int rcycl = 80;
    float c1,c2,c3,c4;
    MoteurDroit.period(T);
    MoteurGauche.period(T);
    while (1) {
        jack=Jack.read();                                                    //Lecture des capteurs
        c1=capt1.read();                                                   //cpt1 : gauche || cpt2 : droit
        c2=capt2.read();
        c3=capt3.read();
        c4=capt4.read();
        switch (etat_confetti) {
            case 0:                                                             //Depart jack
                if (jack==1)                        etat_confetti = 1;
                break;
            case 1: 
                if ((c1 < 0.6) && (c2 < 0.6) && (c3 < 0.6) && (c4 < 0.6))
                                                    etat_confetti = 2;
                break;
            case 2 : 
                if (jack==0)                        etat_confetti = 0;
                break;
        }

        switch (etat_confetti) {
            case 0:                                                             //Arrêt moteurs, jack IN
                MoteurDroit.write(1);
                MoteurGauche.write(1);
                break;
            case 1:
                MoteurDroit.pulsewidth_us(rcycl);                               //Mise en route moteurs en ligne droitre
                MoteurGauche.pulsewidth_us(rcycl);
                break;
            case 3:
                MoteurDroit.write(1);
                MoteurGauche.write(1);
                break;
        }
    }

}

void carre(float fdistance){

DigitalIn jack(D3);
DigitalIn FDC(D2);
PwmOut MoteurDroit(D6);
PwmOut MoteurGauche(D8);
Timer timer;

    int valjack,valFDC,status=0,rcycl_d=79, rcycl_g=80,cote=0;
    float vitesse = 0.4;
    float temps = (fdistance/vitesse)*1000;     // *1000ms
    MoteurDroit.period(T);
    MoteurGauche.period(T);

    while (1) {
        valjack=jack.read();                                                    //Lecture des capteurs
        valFDC=FDC.read();

        switch (status) {
            case 0:                                                             //Depart jack
                if (valjack==1)                   status=2;
                break;
            case 1:                                                             //Retour status initial jack : attente du jack IN
                if (valjack==0)                   status=0;
                break;
            case 2:                                                             //Si ligne capteur gauche, si ligne capteur droit
                if (valFDC==0)                    status=1;
                timer.start();
                if(cote==4)                       status=1;
                if (timer.read_ms() > temps) {
                    timer.reset();
                    cote++;
                    status=3;
                }
                break;
            case 3:
                if (valFDC==0)                    status=1;
                timer.start();
                if (timer.read_ms() > 955) {
                    timer.reset();
                    status=2;
                }
                break;
        }

        switch (status) {
            case 0:                                                             //Arrêt moteurs, jack IN
                MoteurDroit.write(1);
                MoteurGauche.write(1);
                printf("0\n\r");
                break;
            case 1:                                                             //Arrêt moteurs, FDC actif 1 fois
                MoteurDroit.write(1);
                MoteurGauche.write(1);
                printf("1\n\r");
                break;
            case 2:
                MoteurDroit.pulsewidth_us(rcycl_d);
                MoteurGauche.pulsewidth_us(rcycl_g);
                break;
            case 3:
                MoteurDroit.write(1);
                MoteurGauche.pulsewidth_us(rcycl_g);
                break;
        }
    }
}
