#include "mbed.h"

AnalogIn in(p20);
Serial pc(USBTX, USBRX);

double facteur[6] = { 111.38, 0.1759, 0.0002, -1*pow(10, -7), 4*pow(10, -11), -4*pow(10, -15) }

unsigned short calculDistance(unsigned short volt)
{
    unsigned short distance;
    
    for (int i = 0; i < 5; i++)
        distance += facteur[i]*pow(volt, i);
    
    return distance; 
}

int main()
{
    unsigned short volt;
    int d;
     
    while(1)
    {
        volt = in.read_u16();
        d = calculDistance(volt);
        pc.printf("V: %d, d: %d", volt, d);
        wait(0.1);
    }
}
