#include "mbed.h"
#include "rtos.h"
#include <bitset>
#include <string>

Serial pc(USBTX, USBRX);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

unsigned long tc_periods[9] = {0};
unsigned long period = 0;
bool type_bit = true;
int synchrone = 0;
int count = 0;

bool good = true;

char message[16] = "";
const unsigned long offset = 200;

bitset<16> bits(string("0101010101101000"));

void readTrame()
{
    if (synchrone < 8)
    {
        tc_periods[synchrone] = LPC_TIM2->CR1 / 2;
        synchrone++;
        
        if (synchrone == 8)
        {
            for (int i = 0; i < synchrone; i++)
            {
               period += tc_periods[i]; 
            }
            
            period = period/8;
        }
    }
    else
    {   
        unsigned long tc_count = LPC_TIM2->CR1;
        if (tc_count > (period*2 - offset) && tc_count < (period*2 + offset))
        {
            type_bit = !type_bit;
            good = true;
            
            if (type_bit)
                message[count] = '1';
            else
                message[count] = '0';
                
            count++;
        }
        
        good = !good;
        if (good)
        {
            if (type_bit)
                message[count] = '1';
            else
                message[count] = '0';
                
            count++;
        }
    }
    
    if (led1 == 0)
        led1 = 1;
    else
        led1 = 0;  

    LPC_TIM2->TC = 0;
    LPC_TIM2->IR = 0xFF;
}

void sendTrame(std::bitset<16> bit)
{
    for (int a = 1; a <= bit.size(); a++)
    {
        if (bit.test(bit.size() - a))
        {
            LPC_PWM1->MR1 = SystemCoreClock/2;
            LPC_PWM1->MR2 = 1;
        }
        else
        {
            LPC_PWM1->MR1 = 1;
            LPC_PWM1->MR2 = SystemCoreClock/2;
        }
        
        while(LPC_PWM1->IR != 0x01);
        
        LPC_PWM1->IR = 0xFF;
    }
    
    LPC_PWM1->TCR = 0x0;
    
    pc.printf("%s\n", message);
    
    for ( int i = 0; i < 8; i++)
    {
        pc.printf("%d : \t", tc_periods[i]);
    }
    
    pc.printf("\n%d\n", count);
}

void send(void const *args)
{
    sendTrame(bits);
}

void _send()
{
    if (led1 == 0)
        led1 = 1;
    else
        led1 = 0;            
}

void initialize()
{
    // Set system control
    LPC_SC->PCONP |= (1 << 22) | (1 << 6); // Enable Timer2 et PWM
    LPC_SC->PCLKSEL0 |= (1 << 12); // PClk PWM = CCLK
    LPC_SC->PCLKSEL1 |= (1 << 12); // PClk Timer2 = CCLK

    // Set pin connection
    LPC_PINCON->PINSEL0 |= (3 << 10); // Pin 29 Capture
    LPC_PINCON->PINSEL4 |= (1 << 2);  // Pin 25 PWM

    //Initialize Timer2 for capture

    LPC_TIM2->TC = 0;           // Initialize Time Counter
    LPC_TIM2->PC = 0;           // Initialize Prescale Counter
    LPC_TIM2->PR = 0;           // Initialize Prescale Register
    LPC_TIM2->TCR |= (1 << 1);  // Reset Timer Control Register
    LPC_TIM2->IR = 0xFF;        // Reset Interrupt Register
    LPC_TIM2->CCR |=  (1 << 5) | (1 << 4) | (1 << 3);   // Initialize Capture Control Register
    LPC_TIM2->CTCR = 0x00;

    NVIC_SetVector(TIMER2_IRQn, (uint32_t)&readTrame);
    NVIC_EnableIRQ(TIMER2_IRQn);
    
    LPC_TIM2->TCR = 0x01;       // Start Timer Control Register
    
    //Initialize PWM
    LPC_PWM1->MCR |= (1 << 1) | (1 << 0);   // Initialize Match Control Register Interrupt/Reset
    LPC_PWM1->PCR |= (1 << 10) | (1 << 2);  // Initialize PWM Control Register Output/Double-edge
    
    LPC_PWM1->MR0 = SystemCoreClock;        // Period
    LPC_PWM1->LER |= (1 << 2) | (1 << 1);   // Initialize Latch Enable Register
    LPC_PWM1->TCR = (1 << 0);              // Enable counter
    
    LPC_PWM1->IR = 0xFF; // Reset Interrupt Registe
}

int main()
{
    initialize();
    
    sendTrame(bits);
    
    while(true) {
    }
}
