#ifndef TRAME_HPP
#define TRAME_HPP

#include "mbed.h"

using namespace std;

class Trame
{
public:
    // Constructeur
    Trame(PinName _tx, PinName _rx);
    
    // Envoie une trame pour une commande AT
    void sendATCommand(const char* command, const char* data, int length);
    
    // Envoie une trame pour une requete transmition
    void sendTransmitRequest(const char* destination, const char* data, int length);
    
    //Effectue le checksum d'un AT command
    unsigned char crc8(const char* data, int length);
    
private:
    PinName tx, rx;
};

#endif