#include "trame.hpp"

Trame::Trame(PinName _tx, PinName _rx) :
    tx(_tx),
    rx(_rx)
{
}

void Trame::sendATCommand(const char* command, const char* data, int length)
{
    int tmp = length + 4;   // length (grandeur du data à envoyer) 4 (API(1), FrameID(1), AT Command(2))
    char* trm = new char[tmp + 4];  // 4 (Delimiter(1), Length(2), Checksum(1))
    
    trm[0] = 0x7E;      // Delimiter
    trm[1] = static_cast<char>((tmp >> 8) & 0xFF);   // MSB de length
    trm[2] = static_cast<char>(tmp & 0xFF); // LSB length
    trm[3] = 0x09;      // Type
    trm[4] = 0x01;      // API
    trm[5] = command[0];
    trm[6] = command[1];
    for (int i = 0; i < length; i++)
        trm[7+i] = data[i]; //Data
    trm[7+length] = crc8(trm, tmp + 3);
    
    Serial xbee(tx, rx);
    for (int i = 0; i < tmp + 4; i++)
        xbee.putc(trm[i]); //Transmition des donnees
        
    wait(0.01);
    delete trm;
}

void Trame::sendTransmitRequest(const char* destination, const char* data, int length)
{
    int tmp = length + 14;  // length (grandeur du data à envoyer) 14 (API(1), FrameID(1), MAC(8), 16bit(2), Radius(1), Options(1))
    char* trm = new char[tmp + 4];  // 4 (Delimiter(1), Length(2), Checksum(1))
    
    trm[0] = 0x7E;      // Delimiter
    trm[1] = static_cast<char>((tmp >> 8) & 0xFF);   // MSB de length
    trm[2] = static_cast<char>(tmp & 0xFF); // LSB length
    trm[3] = 0x10;      // Type
    trm[4] = 0x01;      // API
    for (int i = 0; i < 8; i++)
        trm[5 + i] = destination[i]; //Destination
    trm[13] = 0xFF;     // 16 bits address
    trm[14] = 0xFE;     // 16 bits address
    trm[15] = 0x00;     // Radius
    trm[16] = 0x00;     // Options
        
    for (int i = 0; i < length; i++)
        trm[17 + i] = data[i]; // Data
        
    trm[17 + length] = crc8(trm, tmp + 3);
    
    Serial xbee(tx, rx);
    for (int i = 0; i < tmp + 4; i++)
        xbee.putc(trm[i]);
        
    wait(0.01);
    delete trm;
}

unsigned char Trame::crc8(const char* data, int length)
{
    unsigned char crc = 0;
    for (int i = 3; i < length; i++)
        crc += data[i];
    
    return (0xFF - crc);
}

void Trame::checkTrame(char *data, char check, int length)
{
    Serial pc(USBTX, USBRX);
    
    pc.printf("%d : data : ", length);
    
    for (int a = 0; a < length; a++)
    {
        pc.printf("%x ", data[a]);
    }
    pc.printf(": check : %x\n\r", check);
}
