#ifndef ROUTEUR_HPP
#define ROUTEUR_HPP

#include <string>
#include "trame.hpp"

using namespace std;

/* Description de la classe Routeur
*
*  La classe Routeur configure le routeur, reçoit les valeurs des capteurs et les envoie sur le réseau zigBee
*
*/
class Routeur
{
public:
    // Enum pour le type de capteur utilisé par le routeur (selon le fichier de config)
    enum Type { Accelerometer, Switch };
    // Constructeur
    Routeur(PinName _tx, PinName _rx);
    
    // Prend les données du capteur à chaque période définie par le fichier de config
    void getValues();
    
    // Initialise acceleromètre
    void initAccel();
    
    // Envoie les valeurs de acceleromètre
    void sendAccelValues();
    
    // Envoie la valeur d'un capteur sec
    void sendSwitchValue();
    
    // Set le réseau du routeur
    void setPanID(string _pan);
    // Définie quel capteur le routeur va utiliser
    void setType(int t);
    // Définie la période entre chaque prise de données
    void setPeriod(int t);
    
private:
    int readRegister(char reg, char* data);             //
    int readRegisters(char reg, int range, char* dest); // Fonctions nécessaire à l'initialisation et la lecture des valeurs de l'accéléromètre
    int writeRegister(char reg, char data);             //
    
    Trame trame;
    
    string pan;
    int period;
    Type type;
    
    I2C accel;
    DigitalIn piton;
    
    char switchValue[1];
    char accelValues[6];
};

#endif
