#include "routeur.hpp"

#define CTRL_REG1 0x2A
#define DATA_REG_W 0x3A
#define DATA_REG_R 0x3B

#define OUT_X_MSB 0x01

const char COORD_ADRESS[8] = {0x00};    // Adresse 64bits du coordinateur (si tous des 0, le routeur envoie à son coordinateur par défaut)

Routeur::Routeur(PinName _tx, PinName _rx) :
    trame(_tx, _rx),
    accel(p9, p10), // Pin I2C (pour l'accéléromètre)
    piton(p30)      // Pin DigitalIn (pour le contact sec)
{
    // reset le xbee
    DigitalOut reset(p8);
    
    reset = 0;
    wait(0.4);
    reset = 1;
}

void Routeur::setPanID(string _pan)
{
    pan = _pan;
    trame.sendATCommand("ID", pan.c_str(), pan.length());// Set le PANID selon le fichier de config
    trame.sendATCommand("WR", 0, 0);    // Écrit la valeur du PANID en mémoire
    trame.sendATCommand("AC", 0, 0);    // Applique les changements effectués
}

void Routeur::setType(int t)
{
    type = static_cast<Type>(t);    // 0: accéléromètre   1: switch
    if (type == Accelerometer)
        initAccel();
}

void Routeur::setPeriod(int t)
{
    period = t;
}

void Routeur::getValues()
{
    if (type == Accelerometer)
        sendAccelValues();
    else
        sendSwitchValue();
    
    wait(period);
}

void Routeur::initAccel()
{
    // Mise de l'accéléromètre en standby
    writeRegister(CTRL_REG1, 0x10);
    
    // Set offset de l'accéléromètre
    writeRegister(0x31, 0xEE);
    
    // activate de l'accéléromètre
    char c;
    readRegister(CTRL_REG1, &c);
    writeRegister(CTRL_REG1, c | 0x01);
}

void Routeur::sendSwitchValue()
{
    switchValue[0] = piton;
    
    trame.sendTransmitRequest(COORD_ADRESS, switchValue, 1);
}

void Routeur::sendAccelValues()
{
    int ack = readRegisters(OUT_X_MSB, 6, accelValues);
    
    trame.sendTransmitRequest(COORD_ADRESS, accelValues, 6);
}

int Routeur::readRegister(char reg, char* data)
{
    int ack = 0;
    accel.start();
    ack = accel.write(DATA_REG_W);
    ack = accel.write(reg);
    accel.start();
    ack = accel.write(DATA_REG_R);
    data[0] = accel.read(0);
    accel.stop();
    
    return ack;
}

int Routeur::readRegisters(char reg, int range, char* data)
{
    int ack = 0;
    accel.start();
    ack = accel.write(DATA_REG_W);
    ack = accel.write(reg);
    accel.start();
    ack = accel.write(DATA_REG_R);
    for (int i = 0; i < range - 1; i++)
        data[i] = accel.read(1);
    data[range - 1] = accel.read(0);
    accel.stop();
    
    return ack;
}

int Routeur::writeRegister(char reg, char data)
{
    int ack = 0;
    accel.start();
    ack = accel.write(DATA_REG_W);
    ack = accel.write(reg);
    ack = accel.write(data);
    accel.stop();
    
    return ack;
}
