#include "readfile.hpp"

ReadFile::ReadFile()
{}

bool ReadFile::setConfigCoord(Coordinateur *coord, const string filename)
{
    string line;
    ifstream myfile(filename.c_str());
    if (myfile.is_open())
    {
        while (getline(myfile,line))
        {
            if (line[0] != '#')
            {
                // Trouve le PANID dans le fichier de config
                if (line.find("PANID") != string::npos)
                {
                    coord->setPanID(line.substr(6));
                }
                // Trouve le URL dans le fichier de config
                if (line.find("URL") != string::npos)
                {
                    coord->setURL(line.substr(4));
                }
            }
        }
        
        myfile.close(); 
        
        return true;
    }
    
    return false;  
}

bool ReadFile::setConfigRouteur(Routeur *rout, const string filename)
{
    string line;
    ifstream myfile(filename.c_str());
    if (myfile.is_open())
    {
        while (getline(myfile,line))
        {
            if (line[0] != '#')
            {
                // Trouve le PANID dans le fichier de config
                if (line.find("PANID") != string::npos)
                {
                    rout->setPanID(line.substr(6));
                }
                // Trouve le Type de capteur dans le fichier de config
                if (line.find("Type") != string::npos)
                {
                    rout->setType(string2int(line.substr(5))); 
                }
                // Trouve la période entre chaque lecture de capteur dans le fichier de config
                if (line.find("Period") != string::npos)
                {
                    rout->setPeriod(string2int(line.substr(7))); 
                }
            }
        }
        
        myfile.close(); 
        
        return true;
    } 
    
    return false;
}

int ReadFile::string2int(string t)
{
    int value = 0;
    istringstream ss(t);
    ss >> value;
    
    return value;
}