#ifndef COORDINATEUR_HPP
#define COORDINATEUR_HPP

#include <string>
#include <sstream>
#include "trame.hpp"
#include "EthernetInterface.h"
#include "Websocket.h"

using namespace std;

/* Description de la classe Coordinateur
*
*  La classe Coordinateur configure le coordinateur, reçoit les trames du routeurs et envoie les informations à un site web
*
*/ 
class Coordinateur
{
public:
    // Enum pour la machine d'état qui reconstruit les trames reçues
    enum Etat { Start, Length, Length2, Data };

    // Constructeur
    Coordinateur(PinName _tx, PinName _rx);
    // Destructeur
    ~Coordinateur();
    
    // Set le réseau du coordinateur
    void setPanID(string _pan);
    // Initialise la connection ethernet et le websocket
    void setURL(string _url);
    // Attend de recevoir les trames
    void getBytes();
    
private:
    // Machine à état qui reçoit les trames
    void etatTrame(char c);
    // Envoie le data reçu à la page web
    void sendDataToWeb(char *data, int length);
    string intToString(int value);
    
    Trame trame;
    string pan;
    string url;
    Serial xbee;
    Etat etat;
    char length[2];
    int length_int;
    int counter;
    char *data;
    
    EthernetInterface *eth;
    Websocket *ws;
};

#endif
