#include "coordinateur.hpp"

Coordinateur::Coordinateur(PinName _tx, PinName _rx) :
    trame(_tx, _rx), xbee(_tx, _rx), etat(Start)
{
    // Reset le xbee
    DigitalOut reset(p8);
    
    reset = 0;
    wait(0.4);
    reset = 1;
}

Coordinateur::~Coordinateur()
{
    delete data;
}

void Coordinateur::setPanID(string _pan)
{
    pan = _pan;
    trame.sendATCommand("ID", pan.c_str(), pan.length());   // Set le PANID selon le fichier de config
    trame.sendATCommand("WR", 0, 0);    // Écrit la valeur du PANID en mémoire
    trame.sendATCommand("AC", 0, 0);    // Applique les changements effectués
}

void Coordinateur::setURL(string _url)
{
    url = _url;
    
    eth = new EthernetInterface();
    eth->init();
    eth->connect();
    
    ws = new Websocket(const_cast<char*>(url.c_str()));
    ws->connect();
}

void Coordinateur::getBytes()
{
    if (xbee.readable())
    {
        etatTrame(xbee.getc());
    }
}

void Coordinateur::etatTrame(char c)
{
    switch (etat)
    {
        // Trouve les delimiter pour partir la trame
        case Start:
            if (c == 0x7E)
                etat = Length;
            break;
        
        // Prend les MSB de length
        case Length:
            length[0] = c;
            etat = Length2;
            break;
        
        // Prend les LSB de length et calcul le length
        case Length2:
            length[1] = c;
            length_int = (length[0] << 8) | length[1];
            if (length_int == 18 || length_int == 13)
                etat = Data;
            else
                etat = Start;
            counter = 0;
            data = new char[length_int];
            break;
        
        // Prend les datas
        case Data:
            if (c == 0x7E)
                etat = Length;
            else if (counter < length_int)
            {
                data[counter] = c;
                counter++;
            }
            else
            {
                //trame.checkTrame(data, c, length_int);
                sendDataToWeb(data, length_int);
                etat = Start;
            }
            break;
    }
}

void Coordinateur::sendDataToWeb(char *data, int length)
{
    if (length == 13)
    {
        if (data[length - 1] == 0x0)
        {
            ws->send("Le circuit du capteur a contact sec est ouvert.");
        }
        else
        {
            ws->send("Le circuit du capteur a contact sec est ferme.");
        }
    }
    else
    {
        int results[3] = {0};
        
        // Reconstruit la valeur sur 12 bits
        for (int i = 0; i < 3; i++)
        {
            results[i] = (data[i*2 + 12] << 4) | (data[2*i + 13] >> 4);
        }
        
        string temp = "Valeur de l'accelerometre: X:";
        temp += intToString(results[0]);
        temp += " Y:";
        temp += intToString(results[1]);
        temp += " Z:";
        temp += intToString(results[2]);
        
        ws->send(const_cast<char*>(temp.c_str()));
    }
}

string Coordinateur::intToString(int value)
{
    stringstream ss;
    ss << value;
    return ss.str();
}
