#include <bitset>
#include "lib_crc.h"

using namespace std;

struct trame
{
    int length;
    string text;
    
    bitset<8> preambule;
    bitset<8> start_end;
    bitset<8> type_flag;
    bitset<8> charge_utile;
    bitset<640> message;
    bitset<16> crc16;
    
    trame(string msg):
        length(msg.length()*8),
        preambule(0x55),
        start_end(0x7E),
        type_flag(0x0),
        charge_utile(msg.length()),
        crc16(calculate_crc16(const_cast<char*>(msg.c_str()), msg.length()))
    {
        string temp = "";
        
        for (int i = 0; i < msg.length(); i++)
        {
            temp += bitset<8>(msg.c_str()[i]).to_string<char, string::traits_type, string::allocator_type>();
        }
        message = bitset<640>(temp) << (640 - msg.length()*8);
    }
    
    trame(bitset<696> bit)
    {
        bool startFound = false;
        int count = 0;
        while (!startFound)
        {
            if (bit.test(695-count))
            {
                startFound = true;
            }
            else
            {
                count++;
            }
        }
        bit = bit << count - 1;
        
        /*for (int a = 0; a < 8; a++)
        {
            preambule[a] = bit[688+a];
        }
        bit = bit << 8;*/
        
        for (int a = 0; a < 8; a++)
        {
            start_end[a] = bit[688+a];
        }
        bit = bit << 8;
        
        for (int a = 0; a < 8; a++)
        {
            type_flag[a] = bit[688+a];
        }
        bit = bit << 8;
        
        for (int a = 0; a < 8; a++)
        {
            charge_utile[a] = bit[688+a];
        }
        length = static_cast<int>(charge_utile.to_ulong())*8;
        bit = bit << 8;
        
        for (int a = 0; a < length; a++)
        {
            message[a] = bit[696-length+a];
        }
        bit = bit << length;
        
        for (int a = 0; a < 16; a++)
        {
            crc16[a] = bit[680+a];
        }
        
        bitToLetter();
    }
    
    string trameToString()
    {
        string res = preambule.to_string<char, string::traits_type, string::allocator_type>() + "\n\r";
        res += start_end.to_string<char, string::traits_type, string::allocator_type>() + "\n\r";
        res += type_flag.to_string<char, string::traits_type, string::allocator_type>() + "\n\r";
        res += charge_utile.to_string<char, string::traits_type, string::allocator_type>() + "\n\r";
        res += message.to_string<char, string::traits_type, string::allocator_type>() + "\n\r";
        res += crc16.to_string<char, string::traits_type, string::allocator_type>() + "\n\r";
        res += start_end.to_string<char, string::traits_type, string::allocator_type>() + "\n\r";
        
        return res;
    }
    
    void bitToLetter()
    {
        text = "";
        
        for (int a = length/8; a > 0; a--)
        {
            string temp = "";
            
            for (int b = 1; b <= 8; b++)
            {
                if (message.test(a*8-b))
                {
                    temp += "1";
                }
                else
                {
                    temp += "0";
                }
            }
            text += static_cast<unsigned char>(bitset<8>(temp).to_ulong());
        }
    }
    
    bool checkCRC16()
    {
        if (calculate_crc16(const_cast<char*>(text.c_str()), length/8) == crc16.to_ulong())
        {
            return true;
        }
        
        return false;
    }
};
