#include "mbed.h"
#include "rtos.h"

DigitalIn en_1(p15);
DigitalIn en_2(p16);
AnalogIn ea_1(p19);
AnalogIn ea_2(p20);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
Serial pc(USBTX, USBRX);

Thread* lecture_digital;
Thread* affichge;
Ticker timeThread;

int32_t SIGNAL_THREAD_WAKE = 0x2;

int conteur_ticker = 0;
int derniere_lecture = 0;

int derniere_lecture_digital[] = {0,0};
uint32_t donner_analog[5];
bool changement_digital = false;
bool changement_digital_pin[] = {false,false};
float seuil_detection = 0.125 * 5 * 65535;

typedef struct {
    int    pin;
    char   type;
    bool   active;
} message_t;
 
MemoryPool<message_t, 16> mpool;
Queue<message_t, 16> queue;

void message_digital(int pin, bool act){
    message_t *message = mpool.alloc();
    message->pin = pin;
    message->type = 'd';
    message->active = act;
    queue.put(message);
}

uint32_t calc_moyenne(){
    uint32_t somme = donner_analog[0] + donner_analog[1] + donner_analog[2] + donner_analog[3] + donner_analog[4];
    return somme;
}
void lecture_analog() {
    int* conteur = 0;
    
    if((*conteur % 5) == 0){
        //led1 = 1;
        //pc.printf("Conteur = %d \n\r",*conteur);
    } else {
        //led1 = 0;
    }
    *conteur = *conteur + 1;
    /*
    while (true) {
        // synchronisation sur la période d'échantillonnage
        // lecture de l'étampe temporelle 
        // lecture des échantillons analogiques
        // calcul de la nouvelle moyenne courante
        // génération éventuelle d'un événement
    }*/
}
void changement_signal_digital(int pin, int lecture){
    int index;
    if(pin == 15){
        index = 0;
    } else {
        index = 1;
    }
    if((lecture != derniere_lecture_digital[index]) && !(changement_digital_pin[index])){
        //pc.printf("First Lecture: %d last lect: %d changement: %s \n\r", lecture, derniere_lecture_digital[index], changement_digital_pin[index] ? "true" : "false");
        changement_digital_pin[index] = true;
    } else {
        if((lecture == derniere_lecture_digital[index]) && (changement_digital_pin[index])){
            bool etat;
            if(derniere_lecture_digital[index] == 1){
                etat = true;
            } else {
                etat = false;
            }
            //pc.printf("Second Lecture: %d last lect: %d changement: %s \n\r", lecture, derniere_lecture_digital[index], changement_digital_pin[index] ? "true" : "false");
            message_digital(pin,etat);
        }
        changement_digital_pin[index] = false;
    }
    derniere_lecture_digital[index] = lecture;
}
void lecture_num(/*void const *args*/) {
    //ajoute un délais de 50 ms pour la détection
    while (true) {
        Thread::signal_wait(SIGNAL_THREAD_WAKE);
        changement_signal_digital(15,en_1.read());
        changement_signal_digital(16,en_2.read());
        if((changement_digital_pin[0] == true)||(changement_digital_pin[1] == true)){
            changement_digital = true;
        } else {
            changement_digital = false;
        }
        // synchronisation sur la période d'échantillonnage
        // lecture de l'étampe temporelle
        // lecture des échantillons numériques
        // prise en charge du phénomène de rebond
        // génération éventuelle d'un événement
    }
}
void format_digital_message(message_t *message, char *str){
    char etat[30];
    if(message->active == true){
        sprintf(etat, "activer");
    } else {
        sprintf(etat, "deactiver");
    }
    sprintf(str, "La pin %d a ete %s .",message->pin,etat);
}
void collection(void/* const *args*/) {
    while (true) {
        // attente et lecture d'un événement
        // écriture de l'événement en sortie (port série)
        
        //Lire dans la queue
        osEvent evt = queue.get();
        //si 
        if (evt.status == osEventMessage) {
            char texte[250];
            message_t *message = (message_t*)evt.value.p;
            if(message->type == 'd'){
                format_digital_message(message,texte);
            }
            pc.printf("%s \n\r", texte);
            mpool.free(message);
        }
    }
}
void compteur(){
    if((conteur_ticker % 5) == 0){
        //lecture_analog();
    }
    if(((conteur_ticker % 2) == 0) || (changement_digital)){
        lecture_digital->signal_set(SIGNAL_THREAD_WAKE);
    }
    conteur_ticker +=1;
}
int main() {
    // initialisation du RTC
    // démarrage des tâches
    Thread digi;
    Thread aff;
    
    lecture_digital = &digi;
    affichge = &aff;
    
    aff.start(callback(collection));
    digi.start(lecture_num);
    
    timeThread.attach(&compteur,0.05);
    while(1) {
        //compteur();
        //wait(0.05);
    }
}
