// becj2903 - Joseph Marinier

#include "mbed.h"
#include "rtos.h"

#define SIGNAL 1
#define ADDING_INGREDIENT 100 // ms
#define ADDING_4_INGREDIENTS 500 // ms

Semaphore ketchup(2);
Mutex relish;
Mutex mayonnaise;
Semaphore moutarde(2);
Mutex oignon;

Thread thread[4];

Queue<char, 4> *queue;
MemoryPool<long, 4> *pool;

void add_ingredient(Semaphore ingredient) { // in Semaphore
    ingredient.wait();
    
    wait_ms(ADDING_INGREDIENT);
    
    ingredient.release();
}

void add_ingredient(Mutex ingredient) { // in Mutex
    ingredient.lock();
    
    wait_ms(ADDING_INGREDIENT);
    
    ingredient.unlock();
}

void doing_hot_dog_1() {
    DigitalOut led(LED1);
    
    while(true) {
        Thread::signal_wait(SIGNAL); // every_2_seconds
        
        add_ingredient(ketchup);
        add_ingredient(relish);
        
        led = !led;
    }
}

void doing_hot_dog_2() {
    DigitalOut led(LED2);
    
    while(true) {
        Thread::signal_wait(SIGNAL); // every_2_seconds
        
        add_ingredient(moutarde);
        add_ingredient(oignon);
        add_ingredient(mayonnaise);
        
        led = !led;
    }
}

bool passing_to_4 = false;

void doing_hot_dog_3() {
    DigitalOut led(LED3);
    
    while(true) {
        Thread::signal_wait(SIGNAL); // every_2_seconds
        
        add_ingredient(ketchup);
        
        if(passing_to_4) {
            char *message = (char *)pool->alloc();
            message[0] = 'h';
            message[1] = 'o';
            message[2] = 't';
            message[3] = 'd';
            message[4] = 'o';
            message[5] = 'g';
            queue->put(message);
        } else {
            led = !led;
        }
    
        passing_to_4 = !passing_to_4;
    }
}

void doing_hot_dog_4() {
    DigitalOut led(LED4);
    
    while(true) {
        osEvent evt = queue->get();
        if (evt.status == osEventMessage) {
            char *message = (char *)evt.value.p;
            printf("\"%s\" should be \"hotdog\"\r\n", message);
            pool->free((long *)message);
            
            relish.lock();
            mayonnaise.lock();
            moutarde.wait();
            oignon.lock();
            
            wait_ms(ADDING_4_INGREDIENTS);
            
            oignon.unlock();
            moutarde.release();
            mayonnaise.unlock();
            relish.unlock();
            
            led = !led;
        }
    }
}

bool every_2_seconds = false;

void every_second() {
    thread[0].signal_set(SIGNAL);
    
    if(every_2_seconds) {
        thread[1].signal_set(SIGNAL);
        thread[2].signal_set(SIGNAL);
    }
    
    every_2_seconds = !every_2_seconds;
}

int main() {
    queue = &Queue<char, 4>();
    pool = &MemoryPool<long, 4>();

    thread[0] = Thread(osPriorityRealtime);
    thread[0].start(doing_hot_dog_1); // Wow la phrase!
    
    thread[1] = Thread(osPriorityHigh);
    thread[1].start(doing_hot_dog_2); // Ho franchement, c'est cute!
    
    thread[2] = Thread(osPriorityNormal);
    thread[2].start(doing_hot_dog_3); // Hooo wow!
    
    thread[3] = Thread(osPriorityLow);
    thread[3].start(doing_hot_dog_4); // Wow wow wow!
    
    Ticker ticker;
    ticker.attach(&every_second, 1);
    
    Thread::wait(osWaitForever);
}
