/*
Project S5 info
Author : lemy2301
*/

//#include "rtos.h"
#include "RTC.h"

#include "Energymeter.h"
#include "Voltmeter.h"
#include "Amperemeter.h"

Amperemeter* amperemeterIn;
Amperemeter* amperemeterOut;
Voltmeter* voltmeter;

float accumulatedEnergy;
float powerIn;
float powerOut;

void collectData()
{
    float ampIn = amperemeterIn->getCurrent();
    float ampOut = amperemeterOut->getCurrent();
    float voltage = voltmeter->getVoltage();
    
    float puissanceDiff = (ampIn-ampOut)*voltage;
    
    accumulatedEnergy += puissanceDiff;
    powerIn = voltage*ampIn;
    powerOut = voltage*ampOut;
    
    if(accumulatedEnergy < 0)
    {
        accumulatedEnergy = 0;
    }
}

Energymeter::Energymeter(PinName ampIn, PinName ampOut, PinName volt)
{
    
    accumulatedEnergy = 0.0;
    powerIn = 0.0;
    powerOut = 0.0;
    
    amperemeterIn = new Amperemeter(ampIn);
    amperemeterOut = new Amperemeter(ampOut);
    
    //Offset capture at 0A
    amperemeterIn->setOffset(2.2972);
    amperemeterOut->setOffset(2.3125);
    
    voltmeter = new Voltmeter(volt);
    
    RTC::attach(&collectData, RTC::Second);
}

float Energymeter::getEnergy()
{
    return accumulatedEnergy;
}

float Energymeter::getPowerIn()
{
    return powerIn;
}

float Energymeter::getPowerOut()
{
    return powerOut;
}

