#include "ConfigurationFile.h"

ConfigurationFile::ConfigurationFile()
{
   readConfigurationFile("/local/unit.cfg"); 
   readUnitConfiguration();
}

void ConfigurationFile::readConfigurationFile(char *pathName)
{
    LocalFileSystem local("local");
    
    if (!cfg.read(pathName)) 
    {
        error("Failure to read a configuration file.\n");
    }
}

ConfigurationFile::~ConfigurationFile()
{
}

void ConfigurationFile::setIP()
{
    char value[BUFSIZ];
    if (cfg.getValue( "IP", &value[0], sizeof(value))) 
    {
        printf("'%s'='%s'\n", "IP", value);
        string s = value;
        ip = s;
    }
    else
    {
        error("Failure to read IP key");
    }
}

string ConfigurationFile::getIP()
{
    return ip;
}

void ConfigurationFile::setMask()
{
    char value[BUFSIZ];
    if (cfg.getValue( "MASK", &value[0], sizeof(value))) 
    {
        printf("'%s'='%s'\n", "MASK", value);
        string s = value;
        mask = s;
    }
    else
    {
        error("Failure to read MASK key");
    }
}

string ConfigurationFile::getMask()
{
    return mask;
}

void ConfigurationFile::setGateway()
{
    char value[BUFSIZ];
    if (cfg.getValue( "GATEWAY", &value[0], sizeof(value))) 
    {
        printf("'%s'='%s'\r\n", "GATEWAY", value);
        string s = value;
        gateway = s;
    }
    else
    {
        error("Failure to read GATEWAY key");
    }
}

string ConfigurationFile::getGateway()
{
    return gateway;
}

void ConfigurationFile::setURL()
{
    char value[BUFSIZ];
    if (cfg.getValue( "URL", &value[0], sizeof(value))) 
    {
        printf("'%s'='%s'\r\n", "URL", value);
        string s = value;
        url = s;
    }
    else
    {
        error("Failure to read URL key");
    }
}

string ConfigurationFile::getURL()
{
    return url;
}

void ConfigurationFile::setBroadcastPort()
{
    char value[BUFSIZ];
    if (cfg.getValue( "BROADCAST", &value[0], sizeof(value))) 
    {
        printf("'%s'='%s'\r\n", "Broadcast Address", value);
        string s = value;
        broadcastPort = s;
    }
    else
    {
        error("Failure to read Broadcast Address key");
    }
}

int ConfigurationFile::getBroadcastPort()
{
    return atoi(broadcastPort.c_str());
}


void ConfigurationFile::readUnitConfiguration()
{
    setIP();
    setMask();
    setGateway();
    setURL();
    setBroadcastPort();
}

void ConfigurationFile::getUnitConfiguration()
{
    printf("IP : %s\r\n",getIP());
    printf("Mask : %s\r\n",getMask());
    printf("Gateway : %s\r\n",getGateway());
    printf("URL : %s\r\n",getURL());
    printf("BroadcastPort : %i,\r\n",getBroadcastPort());
}