#include "mbed.h"
 
//Number of dutycycle steps for output wave
#define TRI_STEPS          33

//Frequency of output sine in Hz
#define TRI_OUT_FREQ       1
               
//Frequency of Pulse Width Modulated signal in Hz
#define PWM_FREQ           6600

float tri_duty[TRI_STEPS];
 
//PWM pin
PwmOut mypwm(D10);
 
//Heartbeat LED
DigitalOut myled(LED1);
 
//Ticker to update the PWM dutycycle
Ticker pwm_ticker;
 
//Ticker calls this fucntion to update the PWM dutycycle
void pwm_duty_updater() {
  static int idx = 0;
  mypwm.write(tri_duty[idx]);   // Set the dutycycle % to next value in array
  idx++;                         // Increment the idx
  if (idx == TRI_STEPS) idx=0;  // Reset the idx when the end has been reached  
}
  
int main() {
    float tri[] =    {0,
                      0.0625,
                      0.125,
                      0.1875,
                      0.25,
                      0.3125,
                      0.375,
                      0.4375,
                      0.5,
                      0.5625,
                      0.625,
                      0.6875,
                      0.75,
                      0.8125,
                      0.875,
                      0.9375,
                      1,
                      0.9375,
                      0.875,
                      0.8125,
                      0.75,
                      0.6875,
                      0.625,
                      0.5625,
                      0.5,
                      0.4375,
                      0.375,
                      0.3125,
                      0.25,
                      0.1875,
                      0.125,
                      0.0625,
                      0};
                      
    for (int i = 0; i < TRI_STEPS; i++)    {
        tri_duty[i] = tri[i];
    }
                      
    // Set PWM frequency
    mypwm.period( 1.0f / (float) PWM_FREQ);
 
    // Init the Ticker to call the dutycyle updater at the required interval
    // The update should be at (SINE_STEPS * SINE_OUT_FREQ) 
    pwm_ticker.attach(&pwm_duty_updater, 1.0f / (float)(TRI_STEPS * TRI_OUT_FREQ));
 
    while(1){ //infinite loop
    myled = !myled; 
    wait(0.5);  
  }
}