#include "mbed.h"
 
//Number of dutycycle steps for output wave
#define SINE_STEPS          33

//Frequency of output sine in Hz
#define SINE_OUT_FREQ       1
 
//Frequency of Pulse Width Modulated signal in Hz
#define PWM_FREQ            6600

float sine_duty[SINE_STEPS];
 
//PWM pin
PwmOut mypwm(D10);
 
//Heartbeat LED
DigitalOut myled(LED1);
 
//Ticker to update the PWM dutycycle
Ticker pwm_ticker;
 
//Ticker calls this fucntion to update the PWM dutycycle
void pwm_duty_updater() {
  static int idx = 0;
  mypwm.write(sine_duty[idx]);   // Set the dutycycle % to next value in array
  idx++;                         // Increment the idx
  if (idx == SINE_STEPS) idx=0;  // Reset the idx when the end has been reached  
}
  
int main() {
    float sine[] =   {0,
                      0.09801714,
                      0.195090322,
                      0.290284677,
                      0.382683432,
                      0.471396737,
                      0.555570233,
                      0.634393284,
                      0.707106781,
                      0.773010453,
                      0.831469612,
                      0.881921264,
                      0.923879533,
                      0.956940336,
                      0.98078528,
                      0.995184727,
                      1,
                      0.5184727,
                      0.98078528,
                      0.956940336,
                      0.923879533,
                      0.881921264,
                      0.831469612,
                      0.773010453,
                      0.707106781,
                      0.634393284,
                      0.555570233,
                      0.471396737,
                      0.382683432,
                      0.290284677,
                      0.195090322,
                      0.09801714,
                      0};
                      
    for (int i = 0; i < SINE_STEPS; i++)    {
        sine_duty[i] = sine[i];
    }
                      
    // Set PWM frequency
    mypwm.period( 1.0f / (float) PWM_FREQ);
 
    // Init the Ticker to call the dutycyle updater at the required interval
    // The update should be at (SINE_STEPS * SINE_OUT_FREQ) 
    pwm_ticker.attach(&pwm_duty_updater, 1.0f / (float)(SINE_STEPS * SINE_OUT_FREQ));
 
    while(1){ //infinite loop
    myled = !myled; 
    wait(0.5);  
  }
}