#include "mbed.h"
 
//Number of dutycycle steps for output wave
#define SAW_STEPS          33

//Frequency of output sine in Hz
#define SAW_OUT_FREQ       1
 
//Frequency of Pulse Width Modulated signal in Hz
#define PWM_FREQ            6600

float saw_duty[SAW_STEPS];
 
//PWM pin
PwmOut mypwm(D10);
 
//Heartbeat LED
DigitalOut myled(LED1);
 
//Ticker to update the PWM dutycycle
Ticker pwm_ticker;
 
//Ticker calls this fucntion to update the PWM dutycycle
void pwm_duty_updater() {
  static int idx = 0;
  mypwm.write(saw_duty[idx]);   // Set the dutycycle % to next value in array
  idx++;                         // Increment the idx
  if (idx == SAW_STEPS) idx=0;  // Reset the idx when the end has been reached  
}
  
int main() {
    float saw[] =   {0,
                     0.03125,
                     0.0625,
                     0.09375,
                     0.125,
                     0.15625,
                     0.1875,
                     0.21875,
                     0.25,
                     0.28125,
                     0.3125,
                     0.34375,
                     0.375,
                     0.40625,
                     0.4375,
                     0.46875,
                     0.5,
                     0.53125,
                     0.5625,
                     0.59375,
                     0.625,
                     0.65625,
                     0.6875,
                     0.71875,
                     0.75,
                     0.78125,
                     0.8125,
                     0.84375,
                     0.875,
                     0.90625,
                     0.9375,
                     0.96875,
                     1};
                      
    for (int i = 0; i < SAW_STEPS; i++)    {
        saw_duty[i] = saw[i];
    }
                      
    // Set PWM frequency
    mypwm.period( 1.0f / (float) PWM_FREQ);
 
    // Init the Ticker to call the dutycyle updater at the required interval
    // The update should be at (SINE_STEPS * SINE_OUT_FREQ) 
    pwm_ticker.attach(&pwm_duty_updater, 1.0f / (float)(SAW_STEPS * SAW_OUT_FREQ));
 
    while(1){ //infinite loop
    myled = !myled; 
    wait(0.5);  
  }
}