/*
    main.cpp comportant la machine d'état.
    Les fonctions appelées par ce main doivent être déclarées dans des headers.
 */

#include <stdio.h>
#include "mbed.h"
#include "WakeUp.h"
#include "../Headers/period.h"
#include "../Headers/states.h"
#include "../Headers/constants.h"
#include "../Headers/ecran.h"
#include "../Headers/poids.h"
#include "../Headers/send.h"
#include "../Headers/refreshScreen.h"
#include "../Headers/standby.h"


Serial pc(USBTX, USBRX);    // serie USB (ne pas oublier de souder sur la carte)
InterruptIn bouton(PA_0);   // bouton bleu en interuption     

State state = Start;        // état de base : start
int poidsRuche;

int poids = 17;
int temp = 21;
int hum = 92;

int main ()
{
    //Ecran::print;
    refreshScreen();
    poidsRuche = Poids::get();
    while(true)
    {
        bouton.rise(&refreshScreen);
        switch(state)
        {
            case Start:
                pc.printf("State Start\n");
                //TODO Test jour ou nuit

                //TODO SI jour, Etat suivant = DeepSleepShort
                //TODO SI nuit, Etat suivant = DeepSleepLong
                state = Send;
                break;
            case DeepSleepShort:
                pc.printf("State DeepSleepShort\n");
                standby(DEEPSLEEP_SHORT_DURATION);
                state = Start;
                break;
            case DeepSleepLong:
                pc.printf("State DeepSleepLong\n");
                standby(DEEPSLEEP_LONG_DURATION);
                state = Start;
                break;
            case MesPHT:
                pc.printf("State MesPHT\n");
                //TODO Ajouter appel à mesPHT(...)

                //TODO Test poids

                //TODO SI poids < 5 Kg, Etat suivant = MesGPS
                //TODO SINON Etat suivant = Send
                break;
            case MesGPS:
                pc.printf("State MesGPS\n");
                //TODO Ajouter appel à mesGPS(...)
                break;
            case Send:
                pc.printf("State Send\n");
                //TODO Ajouter appel à send(...)
                send(poids,temp,hum);
                //TODO Test jour ou nuit

                //TODO SI jour, Etat suivant = DeepSleepShort
                //TODO SI nuit, Etat suivant = DeepSleepLong
                state = Start;
                break;
            default:
                pc.printf("State Error\n");
                state = Start;
        }//end switch
    }//end while
}//end main
