#include "mbed.h"
#include "EPD_GDE021A1.h"
#include "../Headers/refreshScreen.h"

#define EPD_CS       PA_15
#define EPD_DC       PB_11
#define EPD_RESET    PB_2
#define EPD_BUSY     PA_8
#define EPD_POWER    PB_10
#define EPD_SPI_MOSI PB_5
#define EPD_SPI_MISO PB_4
#define EPD_SPI_SCK  PB_3

#define TAILLE_LIGNE  25

EPD_GDE021A1 epd(EPD_CS, EPD_DC, EPD_RESET, EPD_BUSY, EPD_POWER, EPD_SPI_MOSI, EPD_SPI_MISO, EPD_SPI_SCK);//Parametre l'ecrant E-Ink

void refreshScreen()
{
    char ligne0[TAILLE_LIGNE];
    char ligne1[TAILLE_LIGNE];
    char ligne2[TAILLE_LIGNE];
    char ligne3[TAILLE_LIGNE];
    char ligne4[TAILLE_LIGNE];
    char ligne5[TAILLE_LIGNE];
    double poidsRuche;
    double temperatureRuche;
    double humiditeRuche;
    
    poidsRuche = 48.26;
    temperatureRuche = 12.3;
    humiditeRuche = 52.4;
    
    sprintf (ligne0, "Poids       =  %3.2f Kg", poidsRuche); 
    sprintf (ligne1, "Temperature =  %2.1f C", temperatureRuche); 
    sprintf (ligne2, "Humidite    =  %2.1f %%", humiditeRuche); 
    sprintf (ligne3, "123456789012345678901234"); 
    sprintf (ligne4, "123456789012345678901234"); 
    sprintf (ligne5, "123456789012345678901234");  
    /*
    sprintf (ligne2, "Le poids est de %3f Kg",poidsRuche);  
    sprintf (ligne3, "La temperature est de %3f C",temperatureRuche);  
    sprintf (ligne4, "L'humidite est de %3f %",humiditeRuche);    
    sprintf (ligne5, "on met autre chose");  
    */
    
    epd.Clear(EPD_COLOR_WHITE);  

    epd.DisplayStringAtLine(5, (uint8_t*)ligne0, LEFT_MODE);
    epd.DisplayStringAtLine(4, (uint8_t*)ligne1, LEFT_MODE);
    epd.DisplayStringAtLine(3, (uint8_t*)ligne2, LEFT_MODE);
    epd.DisplayStringAtLine(2, (uint8_t*)ligne3, LEFT_MODE);
    epd.DisplayStringAtLine(1, (uint8_t*)ligne4, LEFT_MODE);
    epd.DisplayStringAtLine(0, (uint8_t*)ligne5, LEFT_MODE);
    
    
    epd.RefreshDisplay();

}