#include "mbed.h"
#include "Rtc_Ds1307.h"

//pc_13 = SCL
//pc_14 = SDA

//RtcCls rtc(p28, p27, p29, true);
Rtc_Ds1307 rtc(PB_11, PB_10);

Serial pc(USBTX, USBRX);

char buffer[128];
int readptr = 0;

int main() {
    pc.printf("coucou\n");
    char c;
    Rtc_Ds1307::Time_rtc tm = {};
    
    while(1) {
        pc.printf("*************************************\n");
        pc.printf("* Menu for RTC Test :               *\n");
        pc.printf("* read  - reads the clock           *\n");
        pc.printf("* start - start the clock           *\n");
        pc.printf("* stop  - stop the clock            *\n");
        pc.printf("* write - write the clock           *\n");
        pc.printf("* ena   - enable Square wave output *\n");
        pc.printf("* dis   - disable square wave outp. *\n");
        pc.printf("*************************************\n");
        
        while( (c = pc.getc()) != '\n') {
            buffer[readptr++] = c;
        }
        buffer[readptr++] = 0;
        if (strncmp(buffer, "read", 4) == 0) {
            //  perform read
            pc.printf("Performing read operation\n");
            if (rtc.getTime(tm) ) {
                pc.printf("The current time is : %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
                pc.printf("The current date is : %s, %02d/%02d/%04d\n", rtc.weekdayToString(tm.wday), tm.mon, tm.date, tm.year);
            }
            
        }
        else if (strncmp(buffer, "write", 5) == 0) {
            //  perform write
            /*
            pc.printf("Enter the date (date 0..31)");
            pc.scanf("%d", &tm.date);
            pc.printf("Enter the date (month 1..12)");
            pc.scanf("%d", &tm.mon);
            pc.printf("Enter the date (year)");
            pc.scanf("%d", &tm.year);
            pc.printf("Enter the time (hours 0..23)");
            pc.scanf("%d", &tm.hour);
            pc.printf("Enter the time (minutes 0..59)");
            pc.scanf("%d", &tm.min);
            pc.printf("Enter the time (seconds 0..59)");
            pc.scanf("%d", &tm.sec);
            pc.printf("Performing write operation\n");
            */
            
            tm.date=2;
            tm.mon=12;
            tm.year=2016;
            tm.hour=10;
            tm.min=45;
            tm.sec=50;
            pc.printf("test 1\n");
            while(pc.readable()) 
                pc.getc();
            rtc.setTime(tm, false, false);
            pc.printf("test 2\n");
        }
        else if (strncmp(buffer, "start", 5) == 0) {
            //  start
            pc.printf("Performing start operation\n");
            rtc.startClock();
        }
        else if (strncmp(buffer, "stop", 4) == 0) {
            //  stop
            pc.printf("Performing stop operation\n");
            rtc.stopClock();
        }
        else if (strncmp(buffer, "ena", 3) == 0) {
            int rs;
            pc.printf("Please specify the frequency : [0 = 1Hz, 1 = 4.096kHz, 2 = 8.192kHz, 3 = 32.768kHz] ");
            scanf("%d", &rs);
            pc.printf("Enabling the output with %d option\n", rs);
            rtc.setSquareWaveOutput(true, (Rtc_Ds1307::SqwRateSelect_t)rs);
        }
        else if (strncmp(buffer, "dis", 3) == 0) {
            pc.printf("Disableing square wave output\n");
            rtc.setSquareWaveOutput(false, Rtc_Ds1307::RS1Hz);
        }
        else {
            pc.printf("syntax error\n");
        }
        readptr = 0;
        pc.printf("\n\n\n");
    }
}
