// show how the DS1307 class works
#include "ds1307.h"
#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx  for debug and usb pc comunications

DS1307 my1307(PA_14,PA_13); // start DS1307 class and give it pins for connections of the DS1307 device

int sec = 0;
int min = 0;
int hours = 0;
int day = 0;
int date = 0;
int month = 0;
int year = 0;

void test_rw(int test) {
    if (test == 0) pc.printf("Last R/W operaion passed!\n\r");
    else pc.printf("Last R/W operation failed!\n\r");
}

int main() {
    int junk = 0;

    sec = 24;       // 24 seconds
    min = 13;       // 13 min
    hours = 13;     // 1 pm
    day = 4;        // wednesday
    date = 20;      // June 20
    month = 6;
    year = 12;      // 2012
                    // set time to these values on the ds1307 connected device

    test_rw(my1307.settime( sec, min, hours, day, date, month, year));
    pc.printf("seconds set are %.2D \n\r",sec);
    pc.printf("min set are %.2D \n\r",min);
    pc.printf("hour set are %.2D \n\r",hours);
    pc.printf("day set are %.2D \n\r",day);
    pc.printf("date set are %.2D \n\r",date);
    pc.printf("month set are %.2D \n\r",month);
    pc.printf("year set are %.2D \n\r",year);
    wait(3);
                    // now read the time of the DS1307 device and see what time it is
                    // note that because of the 3 second wait this time should be 3 seconds past what it was set to earlier

    test_rw(my1307.gettime( &sec, &min, &hours, &day, &date, &month, &year));
    pc.printf("seconds read are %.2D \n\r",sec);
    pc.printf("min read are %.2D \n\r",min);
    pc.printf("hour read are %.2D \n\r",hours);
    pc.printf("day read are %.2D \n\r",day);
    pc.printf("date read are %.2D \n\r",date);
    pc.printf("month read are %.2D \n\r",month);
    pc.printf("year read are %.2D \n\r",year);

    junk = 0x39;                            // just a junk value do read and write test to DS1307 ram
    test_rw(my1307.write( 0x20, junk));     // this should write the value of junk to register 0x20 (a ram location) in the ds1307.
    pc.printf("Value written to register 0x20 %.2X \n\r",junk);
    junk = 0;                               // clear junk to show that when the register is read from the correct value is obtained
    test_rw(my1307.read( 0x20, &junk));     // this should read register 0x20
    pc.printf("Value read from register 0x20 %.2X \n\r",junk);
}
