#include "mbed.h"
 
SPI spiR(p11, p12, p13);  // mosi, miso, sclk
DigitalOut lpR(p10);
DigitalOut bpR(p14);
 
SPI spiL(p5, p6, p7);
DigitalOut lpL(p8);
DigitalOut bpL(p9);
 
void latch()
{
    lpR = 1;
    lpL = 1;
    lpR = 1;
    lpL = 1;
    lpR = 1;
    lpL = 1;
    lpR = 0;
    lpL = 0;
}
 
 
 
//FREQ CONTROL CONFIG
 
Ticker tick;
InterruptIn in(p22);
Timer t1;
Timer t2;
 
//INTERRUPT FEEDBACK LED
 
DigitalOut led(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
 
//RUNTIME VARS
 
float t_period = 0;                   // This is the period between interrupts in microseconds
float t_freq = 0;
int last = -1;
float curt = 0;
int f = 0;
 
//DUMMY FUNCTION AS THERE IS NO HEADER FILE
 
void flip();
void flip()
{
    t_period = t1.read_us();                // Get time since last interrupt
    t_freq = (1/(float)t_period)*1000000;   // Convert period (in us) to frequency (Hz)
    t1.reset();                             // Reset timer and wait for next interrupt
    t2.reset();
    led = !led;
    f++;
}
 
short outp[48][48]= {{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0xFFF,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
};
 
//short actualrowR[48]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
//short actualrowL[48]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int x,j;
 
short actualrowR[24]= {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
short actualrowL[24]= {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 
short cakeempty[24]= {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
short cakefull[24]= {0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,
                     0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF
                    };
 
short radaroff[24]= {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
short radaron[24]= {0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,
                    0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF,0xFFF
                   };
short radardot[24]= {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFFF,0,0,0,0,0,0,0,0};
 
int lookupport(int j)
{
    int led, p;
 
    if(j%2 == 1)            //Alle ungeradezahligen Ports
        //werden vom rechten Controller angesteuert
        //entsprechend wird "R" als "Side" zugewiesen
    {
 
        p = j/2;          //Durch Division /2 bekommen wir eine "normierte Reihe" also (0,1 ,2 ... 12)
 
        if (p%2 == 0)          //nochmal %2 da Ports sich abwechseln (0, 23, 1, 22... siehe Tabelle)
            led = 23 - (p/2);  //also von "p" ausgegangen, beginnen gerade Zahlen von hinten an (Ports 23, 22, 21... 12)
        else
            led = (p/2);   // ungerade Zahlen beginnen von vorne an (Port 0, 1, 2... 11)
    }
 
    else
 
    {
        p = (j-1)/2;
 
        if (p%2 == 0)
            led = 23 - (p/2);
        else
            led = (p/2);
    }
    return led;
 
}
 
//returns 1 if right Port, else 0
int lookupLR(int j)
{
    return j % 2;
}
 
//Hier kommt die Funktion
 
 
int main()
{
 
    lpR = 0;
    lpL = 0;
    spiR.format(12, 0);
    spiR.frequency(30 * 1000 * 1000);
    spiL.format(12, 0);
    spiL.frequency(30 * 1000 * 1000);
    bpR=1;
    bpL = 1;
 
    /*
    LocalFileSystem local("local");
    FILE *fp;
    fp = fopen("/local/curstate.txt", "a+");  // Open "out.txt" on the local file system for writing
 
    if (fp==NULL) {
        fp = freopen("/local/curstate.txt","w", fp);
        led =1;
        freopen(NULL, "r",fp);
 
        //error("File could not be opened!");
    }
    led4 = 1;
    int cstate = fgetc(fp);
    int state = -1;
    if (cstate == EOF) {
        freopen(NULL, "w", fp);
        if (fputc('0',fp) == EOF) {
            led2=1;
            //error("File can not be used!");
        }
        freopen(NULL, "r", fp);
    }
    led4 =1;
    switch (cstate) {
        case '0': {
            state = 0;
            break;
        }
        case '1': {
            state = 1;
            break;
        }
        case '2': {
            state = 2;
            break;
        }
        default: {
            freopen(NULL, "r", fp);
            if (fputc('0',fp) == EOF) {
                led3=1;
                //error("File can not be used!");
            }
            freopen(NULL, "r", fp);
            state = 0;
            break;
        }
    }
 
    fclose(fp);
    */
 
 
 
    for (int v = 0; v<5; ++v)   {
 
        for(int i=47; i>=0; i--) {
            bpR=1;
            bpL = 1;
            for(int j = 0; j<sizeof(outp[0])/sizeof(outp[0][0]); j++) {
                if (lookupLR(j)) {
                    actualrowR[lookupport(j)] = outp[i][j];
                } else {
                    actualrowL[lookupport(j)] = outp[i][j];
                }
            }
            for (int k =0; k<sizeof(actualrowR)/sizeof(actualrowR[0]); ++k) {
                spiR.write(actualrowR[k]);
            }
            for (int k =0; k<sizeof(actualrowL)/sizeof(actualrowL[0]); ++k) {
                spiL.write(actualrowL[k]);
            }
            latch();
            bpR=0;
            bpL = 0;
            wait(0.08);
        }
        for(int i=0; i<sizeof(outp)/sizeof(outp[0]); i++) {
            bpR=1;
            bpL = 1;
            for(int j = 0; j<sizeof(outp[0])/sizeof(outp[0][0]); j++) {
                if (lookupLR(j)) {
                    actualrowR[lookupport(j)] = outp[i][j];
                } else {
                    actualrowL[lookupport(j)] = outp[i][j];
                }
            }
            for (int k =0; k<sizeof(actualrowR)/sizeof(actualrowR[0]); ++k) {
                spiR.write(actualrowR[k]);
            }
            for (int k =0; k<sizeof(actualrowL)/sizeof(actualrowL[0]); ++k) {
                spiL.write(actualrowL[k]);
            }
            latch();
            bpR=0;
            bpL = 0;
            wait(0.08);
        }
 
    }
 
    //****************************//
    //CAKE FUNCTION - YUM YUM
    //****************************//
 
 
    {
        in.mode(PullDown);              // Set the pin to Pull Down mode.
        in.rise(&flip);                 // Set up the interrupt for rising edge
        t1.start();                     // start the timer
        t2.start();
 
        for(; f<500;) {                  //as a placeholder until we find a way to navigate between programmes
 
            if(t_period == 0) {
                continue;
            }
            curt = t2.read_us();
            if (curt < t_period * 0.135
                    || (t_period/4 < curt && curt < (t_period*0.135)*3 )
                    || (t_period/2 < curt && curt < (t_period/0.135)*5 )
                    || ((t_period/4)*3 < curt && curt < (t_period/0.135)*7 )
               ) {
                if (last != 0) {
                    //cake empty
 
                    bpL=1;
                    bpR=1;
                    for (int j = 0; j<48; j++) {
                        spiR.write(0x000);
                        spiL.write(0x000);
                    }
                    //for(int j=0; j<sizeof(cakeempty)/sizeof(cakeempty[0]); j++) {
                    //  spiR.write(cakeempty[j]);
                    //spiL.write(cakeempty[j]);
                    //}
                    latch();
                    bpL=0;
                    bpR=0;
                    last = 0;
                }
            } else {
                if (last != 1) {
 
                    //cake full
                    bpL=1;
                    bpR=1;
 
                    for (int j = 0; j<48; j++) {
                        spiR.write(0xFFF);
                        spiL.write(0xFFF);
                    }
 
                    //for(int j=0; j<sizeof(cakefull)/sizeof(cakefull[0]); j++) {
                    //  spiR.write(cakefull[j]);
                    //spiL.write(cakefull[j]);
                    //}
                    latch();
                    bpL=0;
                    bpR=0;
                    last = 1;
                }
            }
 
        }
 
 
        /*********************************/
        //    RADAR FUNCTION FUCK YEAH   //
        /**********************************/
 
        f = 0;
        in.mode(PullDown);              // Set the pin to Pull Down mode.
        in.rise(&flip);                 // Set up the interrupt for rising edge
        t1.start();                     // start the timer
        t2.start();
        //t3.start();
 
        lpR = 0;
        lpL = 0;
        bpR=0;
        bpL = 0;
 
        for(; f<500;) {
            bpL=1;
            bpR=1;
            for(j=0; j<sizeof(radaron)/sizeof(radaron[0]); j++) {
                if(j%2==1) {
                    spiR.write(radaron[j]);
                }
            }
            latch();
            bpL=0;
            bpR=0;
            wait(0.15);
 
            //right side off, left side on
            //only if needed
            bpL=1;
            bpR=1;
            for(j=0; j<sizeof(radaroff)/sizeof(radaroff[0]); j++) {
                spiR.write(radaroff[j]);
            }
            bpL=0;
            bpR=0;
            wait(0.15);
 
            //HERE COMES THE DOT, YO
 
            bpL=1;
            for(j=0; j<sizeof(radardot)/sizeof(radardot[0]); j++) {
                spiL.write(radardot[j]);
            }
            latch();
            bpL=0;
            bpR=0;
            wait(0.1);
 
            bpL=1;
            for(j=0; j<sizeof(radardot)/sizeof(radardot[0]); j++) {
                spiL.write(radaroff[j]);
            }
            latch();
            bpL=0;
            bpR=0;
            wait(0.1);
 
            /*
            if(t_period == 0) {
                continue;
            }*/
 
 
 
 
            /* OLD FUNCTION
             *
             *
 
            in.mode(PullDown);              // Set the pin to Pull Down mode.
            in.rise(&flip);                 // Set up the interrupt for rising edge
            t1.start();                     // start the timer
            t2.start();
            int a = 0;
 
            while(1) {                   //as a placeholder until we find a way to navigate between programmes
                a++;
                if(t_period == 0) {
                    continue;
                }
                curt = t2.read_us();
                if (curt !=t_period) {
 
                } else {
                    if (last != 0) {
                        //cake empty
 
                        //HERE COMES THE DOT, YO
 
                        bpL=1;
                        for(j=0; j<sizeof(radardot)/sizeof(radardot[0]); j++) {
                            spiL.write(radardot[j]);
                        }
                        latch();
                        bpL=0;
                        bpR=0;
                        last = 0;
                    }
                    if (last != 1) {
 
                        bpL=1;
                        for(j=0; j<sizeof(radardot)/sizeof(radardot[0]); j++) {
                            spiL.write(radaroff[j]);
                        }
                        latch();
                        bpL=0;
                        bpR=0;
                        last = 1;
                    }
                }
            }
            */
 
 
 
        }
 
 
 
//Please notice that the wait times for the needle and the dot are different - THIS IS INTENDED
 
 
//radaron
 
        /*for(x=0;x<20;x++){
            bpL=1;
            bpR=1;
            for(j=0;j<sizeof(radaron)/sizeof(radaron[0]);j++){
                    spiR.write(radaron[j]);
            }
            latch();
            bpL=0;
            bpR=0;
            wait(0.15);
 
            //radaroff
 
            bpL=1;
            bpR=1;
            for(j=0;j<sizeof(radaroff)/sizeof(radaroff[0]);j++){
            spiR.write(radaroff[j]);
            }
            bpL=0;
            bpR=0;
            wait(0.15);
 
            //HERE COMES THE DOT, YO
 
            bpL=1;
            for(j=0;j<sizeof(radardot)/sizeof(radardot[0]);j++){
                spiL.write(radardot[j]);
            }
            latch();
            bpL=0;
            bpR=0;
            wait(0.1);
 
            bpL=1;
            for(j=0;j<sizeof(radardot)/sizeof(radardot[0]);j++){
                spiL.write(radaroff[j]);
            }
            latch();
            bpL=0;
            bpR=0;
            wait(0.1);
        }*/
    }
    
    }
  